/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization.state.persistence.cookie;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.security.oauth2.endpoint.authorization.CookiePersistence;
import io.micronaut.security.oauth2.endpoint.authorization.state.State;
import io.micronaut.security.oauth2.endpoint.authorization.state.StateSerDes;
import io.micronaut.security.oauth2.endpoint.authorization.state.persistence.StatePersistence;
import io.micronaut.security.oauth2.endpoint.authorization.state.persistence.cookie.CookieStatePersistenceConfiguration;
import jakarta.inject.Singleton;
import java.util.Optional;

@Singleton
public class CookieStatePersistence
extends CookiePersistence
implements StatePersistence {
    private final StateSerDes stateSerDes;

    public CookieStatePersistence(StateSerDes stateSerDes, CookieStatePersistenceConfiguration configuration) {
        super(configuration);
        this.stateSerDes = stateSerDes;
    }

    @Override
    public Optional<State> retrieveState(HttpRequest<?> request) {
        return this.retrieveValue(request).map(this.stateSerDes::deserialize);
    }

    @Override
    public void persistState(HttpRequest<?> request, MutableHttpResponse response, State state) {
        this.save(request, response, this.stateSerDes.serialize(state));
    }
}

