/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.token.response.validation;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.token.response.JWTOpenIdClaims;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdTokenResponse;
import io.micronaut.security.oauth2.endpoint.token.response.validation.NonceClaimValidator;
import io.micronaut.security.oauth2.endpoint.token.response.validation.OpenIdClaimsValidator;
import io.micronaut.security.oauth2.endpoint.token.response.validation.ReactiveOpenIdTokenResponseValidator;
import io.micronaut.security.token.Claims;
import io.micronaut.security.token.jwt.validator.GenericJwtClaimsValidator;
import io.micronaut.security.token.jwt.validator.ReactiveJsonWebTokenValidator;
import jakarta.inject.Singleton;
import java.text.ParseException;
import java.util.Collection;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@Requires(classes={HttpRequest.class})
@Singleton
@Internal
class DefaultReactiveOpenIdTokenResponseValidator
implements ReactiveOpenIdTokenResponseValidator<JWT> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultReactiveOpenIdTokenResponseValidator.class);
    private final Collection<OpenIdClaimsValidator> openIdClaimsValidators;
    private final Collection<GenericJwtClaimsValidator<HttpRequest<?>>> genericJwtClaimsValidators;
    private final NonceClaimValidator nonceClaimValidator;
    private final ReactiveJsonWebTokenValidator<JWT, HttpRequest<?>> jwtTokenValidator;

    public DefaultReactiveOpenIdTokenResponseValidator(@NonNull Collection<OpenIdClaimsValidator> idTokenValidators, @NonNull Collection<GenericJwtClaimsValidator<HttpRequest<?>>> genericJwtClaimsValidators, @Nullable NonceClaimValidator nonceClaimValidator, @NonNull ReactiveJsonWebTokenValidator<JWT, HttpRequest<?>> jwtTokenValidator) {
        this.openIdClaimsValidators = idTokenValidators;
        this.genericJwtClaimsValidators = genericJwtClaimsValidators;
        this.nonceClaimValidator = nonceClaimValidator;
        this.jwtTokenValidator = jwtTokenValidator;
    }

    @Override
    @NonNull
    @SingleResult
    public Publisher<JWT> validate(@NonNull OauthClientConfiguration clientConfiguration, @NonNull OpenIdProviderMetadata openIdProviderMetadata, @NonNull OpenIdTokenResponse openIdTokenResponse, @Nullable String nonce) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Validating the JWT signature using the JWKS uri [{}]", (Object)openIdProviderMetadata.getJwksUri());
        }
        return Mono.from((Publisher)this.jwtTokenValidator.validate(openIdTokenResponse.getIdToken(), (Object)ServerRequestContext.currentRequest().orElse(null))).filter(jwt -> this.validateClaims(clientConfiguration, openIdProviderMetadata, (JWT)jwt, nonce));
    }

    @NonNull
    private boolean validateClaims(@NonNull OauthClientConfiguration clientConfiguration, @NonNull OpenIdProviderMetadata openIdProviderMetadata, @NonNull JWT jwt, @Nullable String nonce) {
        block12: {
            try {
                JWTClaimsSet claimsSet = jwt.getJWTClaimsSet();
                JWTOpenIdClaims claims = new JWTOpenIdClaims(claimsSet);
                if (this.genericJwtClaimsValidators.stream().allMatch(validator -> validator.validate((Claims)claims, null))) {
                    if (this.openIdClaimsValidators.stream().allMatch(validator -> validator.validate(claims, clientConfiguration, openIdProviderMetadata))) {
                        if (this.nonceClaimValidator == null) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Skipping nonce validation because no bean of type {} present. ", (Object)NonceClaimValidator.class.getSimpleName());
                            }
                            return true;
                        }
                        if (this.nonceClaimValidator.validate(claims, clientConfiguration, openIdProviderMetadata, nonce)) {
                            return true;
                        }
                        if (LOG.isErrorEnabled()) {
                            LOG.error("Nonce {} validation failed for claims {}", (Object)nonce, (Object)claims.getClaims().keySet().stream().map(key -> key + "=" + claims.getClaims().get(key)).collect(Collectors.joining(", ", "{", "}")));
                        }
                    } else if (LOG.isErrorEnabled()) {
                        LOG.error("JWT OpenID specific claims validation failed for provider [{}]", (Object)clientConfiguration.getName());
                    }
                } else if (LOG.isErrorEnabled()) {
                    LOG.error("JWT generic claims validation failed for provider [{}]", (Object)clientConfiguration.getName());
                }
            }
            catch (ParseException e) {
                if (!LOG.isErrorEnabled()) break block12;
                LOG.error("Failed to parse the JWT returned from provider [{}]", (Object)clientConfiguration.getName(), (Object)e);
            }
        }
        return false;
    }
}

