/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.token.request.password;

import io.micronaut.context.BeanContext;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.client.condition.AbstractCondition;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.token.response.DefaultOpenIdAuthenticationMapper;
import io.micronaut.security.oauth2.endpoint.token.response.OauthAuthenticationMapper;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdAuthenticationMapper;
import io.micronaut.security.oauth2.endpoint.token.response.validation.ReactiveOpenIdTokenResponseValidator;
import io.micronaut.security.oauth2.grants.GrantType;

@Internal
public class PasswordGrantCondition
extends AbstractCondition {
    @Override
    @NonNull
    protected String getFailureMessagePrefix(@NonNull String name) {
        return "Skipped password grant flow for provider [" + name;
    }

    @Override
    protected boolean handleConfigurationEnabled(@NonNull OauthClientConfiguration clientConfiguration, @NonNull ConditionContext<?> context, @NonNull String failureMsgPrefix) {
        BeanContext beanContext = context.getBeanContext();
        if (clientConfiguration.getGrantType() == GrantType.PASSWORD) {
            if (clientConfiguration.getToken().isPresent()) {
                if (beanContext.containsBean(OauthAuthenticationMapper.class, Qualifiers.byName((String)clientConfiguration.getName()))) {
                    return true;
                }
                context.fail(failureMsgPrefix + "] because no user details mapper could be found");
            } else if (clientConfiguration.getOpenid().isPresent()) {
                String clientConfigurationName = clientConfiguration.getName();
                boolean hasOpenIdProviderMetadata = beanContext.containsBean(OpenIdProviderMetadata.class, Qualifiers.byName((String)clientConfigurationName));
                boolean hasTokenResponseValidator = beanContext.containsBean(ReactiveOpenIdTokenResponseValidator.class);
                if (hasOpenIdProviderMetadata && hasTokenResponseValidator) {
                    boolean hasAuthenticationMapper = beanContext.containsBean(OpenIdAuthenticationMapper.class, Qualifiers.byName((String)clientConfigurationName));
                    if (!hasAuthenticationMapper) {
                        hasAuthenticationMapper = beanContext.containsBean(DefaultOpenIdAuthenticationMapper.class);
                    }
                    if (hasAuthenticationMapper) {
                        return true;
                    }
                    context.fail(failureMsgPrefix + "] because no user details mapper could be found");
                } else {
                    context.fail(failureMsgPrefix + "] because no provider metadata and token validator could be found");
                }
            } else {
                context.fail(failureMsgPrefix + "] because no token endpoint or openid configuration was found");
            }
        } else {
            context.fail(failureMsgPrefix + "] because the grant type is not 'password'");
        }
        return false;
    }
}

