/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization.request;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.OauthAuthorizationEndpointConfiguration;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.DefaultCodeVerifierGenerator;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.DefaultPkceFactory;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.PkceChallenge;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.PkceConfiguration;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.PkceFactory;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.PlainPkceGenerator;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.S256PkceGenerator;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.persistence.cookie.CookiePkcePersistence;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.persistence.cookie.CookiePkcePersistenceConfiguration;
import io.micronaut.security.oauth2.endpoint.authorization.request.OauthAuthorizationRequest;
import io.micronaut.security.oauth2.endpoint.authorization.request.ResponseType;
import io.micronaut.security.oauth2.endpoint.authorization.state.StateFactory;
import io.micronaut.security.oauth2.url.OauthRouteUrlBuilder;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@Prototype
@Internal
class DefaultOauthAuthorizationRequest
implements OauthAuthorizationRequest {
    private final HttpRequest<?> request;
    private final OauthClientConfiguration oauthClientConfiguration;
    private final OauthRouteUrlBuilder oauthRouteUrlBuilder;
    private final StateFactory stateFactory;
    private final PkceFactory pkceFactory;

    @Inject
    DefaultOauthAuthorizationRequest(@Parameter HttpRequest<?> request, @Parameter OauthClientConfiguration oauthClientConfiguration, OauthRouteUrlBuilder oauthRouteUrlBuilder, @Nullable StateFactory stateFactory, @Nullable PkceFactory pkceFactory) {
        this.request = request;
        this.oauthClientConfiguration = oauthClientConfiguration;
        this.oauthRouteUrlBuilder = oauthRouteUrlBuilder;
        this.stateFactory = stateFactory;
        this.pkceFactory = pkceFactory;
    }

    @Deprecated
    DefaultOauthAuthorizationRequest(@Parameter HttpRequest<?> request, @Parameter OauthClientConfiguration oauthClientConfiguration, OauthRouteUrlBuilder oauthRouteUrlBuilder, @Nullable StateFactory stateFactory) {
        this(request, oauthClientConfiguration, oauthRouteUrlBuilder, stateFactory, DefaultOauthAuthorizationRequest.defaultDefaultPkceFactory());
    }

    @Deprecated
    private static PkceFactory defaultDefaultPkceFactory() {
        return new DefaultPkceFactory(Arrays.asList(new S256PkceGenerator(new DefaultCodeVerifierGenerator(DefaultOauthAuthorizationRequest.defaultPkceConfiguration())), new PlainPkceGenerator(new DefaultCodeVerifierGenerator(DefaultOauthAuthorizationRequest.defaultPkceConfiguration()))), new CookiePkcePersistence(new CookiePkcePersistenceConfiguration()));
    }

    @Deprecated
    private static PkceConfiguration defaultPkceConfiguration() {
        return new PkceConfiguration(){

            @Override
            public int getEntropy() {
                return 64;
            }

            @Override
            @NonNull
            public Optional<String> getPersistence() {
                return Optional.of("cookie");
            }
        };
    }

    @Override
    @NonNull
    public String getClientId() {
        return this.oauthClientConfiguration.getClientId();
    }

    public Optional<String> getState(MutableHttpResponse response) {
        return Optional.ofNullable(this.stateFactory).map(sf -> sf.buildState(this.request, response, this));
    }

    @Override
    @NonNull
    public Optional<PkceChallenge> getPkceChallenge(@NonNull MutableHttpResponse<?> response) {
        return this.oauthClientConfiguration.getAuthorization().flatMap(OauthAuthorizationEndpointConfiguration::getCodeChallengeMethod).flatMap(codeChallengeMethod -> this.pkceFactory == null ? Optional.empty() : this.pkceFactory.buildChallenge(this.request, response, Collections.singletonList(codeChallengeMethod)).map(PkceChallenge.class::cast));
    }

    @Override
    @NonNull
    public List<String> getScopes() {
        return this.oauthClientConfiguration.getScopes();
    }

    @Override
    @NonNull
    public String getResponseType() {
        return ResponseType.CODE.toString();
    }

    @Override
    public Optional<String> getRedirectUri() {
        return Optional.of(this.oauthRouteUrlBuilder.buildCallbackUrl(this.request, this.oauthClientConfiguration.getName()).toString());
    }
}

