/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.token.response.validation;

import io.micronaut.context.annotation.Requires;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdClaims;
import io.micronaut.security.oauth2.endpoint.token.response.validation.OpenIdClaimsValidator;
import jakarta.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(property="micronaut.security.oauth2.openid.claims-validation.authorized-party", notEquals="false")
@Singleton
public class AuthorizedPartyClaimValidator
implements OpenIdClaimsValidator {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizedPartyClaimValidator.class);

    @Override
    public boolean validate(OpenIdClaims claims, OauthClientConfiguration clientConfiguration, OpenIdProviderMetadata providerMetadata) {
        String authorizedParty = claims.getAuthorizedParty();
        if (authorizedParty == null) {
            return true;
        }
        boolean condition = authorizedParty.equals(clientConfiguration.getClientId());
        if (!condition && LOG.isTraceEnabled()) {
            LOG.trace("JWT validation failed for provider [{}]. Authorized party claim does not match [{}]", (Object)clientConfiguration.getName(), (Object)clientConfiguration.getClientId());
        }
        return condition;
    }
}

