/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.routes;

import io.micronaut.context.BeanContext;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.ExecutionHandle;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.oauth2.client.OauthClient;
import io.micronaut.security.oauth2.client.OpenIdClient;
import io.micronaut.security.oauth2.configuration.OauthConfiguration;
import io.micronaut.security.oauth2.routes.EndSessionController;
import io.micronaut.security.oauth2.routes.OauthController;
import io.micronaut.security.oauth2.url.OauthRouteUrlBuilder;
import io.micronaut.security.utils.LoggingUtils;
import io.micronaut.web.router.DefaultRouteBuilder;
import io.micronaut.web.router.RouteBuilder;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Internal
class OauthRouteBuilder
extends DefaultRouteBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(OauthRouteBuilder.class);

    OauthRouteBuilder(ExecutionHandleLocator executionHandleLocator, RouteBuilder.UriNamingStrategy uriNamingStrategy, ConversionService<?> conversionService, BeanContext beanContext, OauthConfiguration oauthConfiguration, OauthRouteUrlBuilder oauthRouteUrlBuilder, List<OauthController> controllerList) {
        super(executionHandleLocator, uriNamingStrategy, conversionService);
        if (controllerList.isEmpty()) {
            LoggingUtils.debug((Logger)LOG, (String)"No Oauth controllers found. Skipping registration of routes", (Object[])new Object[0]);
        } else {
            AtomicBoolean endSessionRegistered = new AtomicBoolean();
            controllerList.forEach(controller -> {
                OauthClient client = controller.getClient();
                String name = client.getName();
                boolean isDefaultProvider = oauthConfiguration.getDefaultProvider().filter(provider -> provider.equals(name)).isPresent();
                BeanDefinition bd = beanContext.getBeanDefinition(OauthController.class, Qualifiers.byName((String)name));
                bd.findMethod("login", new Class[]{HttpRequest.class}).ifPresent(m -> {
                    String loginPath = oauthRouteUrlBuilder.buildLoginUri(name).getPath();
                    LoggingUtils.debug((Logger)LOG, (String)"Registering login route [GET: {}] for oauth configuration [{}]", (Object[])new Object[]{loginPath, name});
                    this.buildRoute(HttpMethod.GET, loginPath, ExecutionHandle.of((Object)controller, (ExecutableMethod)m));
                    if (isDefaultProvider) {
                        String defaultLoginPath = oauthRouteUrlBuilder.buildLoginUri(null).getPath();
                        LoggingUtils.debug((Logger)LOG, (String)"Registering default login route [GET: {}] for oauth configuration [{}]", (Object[])new Object[]{defaultLoginPath, name});
                        this.buildRoute(HttpMethod.GET, defaultLoginPath, ExecutionHandle.of((Object)controller, (ExecutableMethod)m));
                    }
                });
                bd.findMethod("callback", new Class[]{HttpRequest.class}).ifPresent(m -> {
                    String callbackPath = oauthRouteUrlBuilder.buildCallbackUri(name).getPath();
                    MethodExecutionHandle executionHandle = ExecutionHandle.of((Object)controller, (ExecutableMethod)m);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Registering callback route [GET: {}] for oauth configuration [{}]", (Object)callbackPath, (Object)name);
                        LOG.debug("Registering callback route [POST: {}] for oauth configuration [{}]", (Object)callbackPath, (Object)name);
                    }
                    this.buildRoute(HttpMethod.GET, callbackPath, executionHandle);
                    this.buildRoute(HttpMethod.POST, callbackPath, executionHandle).consumes(new MediaType[]{MediaType.APPLICATION_FORM_URLENCODED_TYPE});
                    if (isDefaultProvider) {
                        String defaultCallbackPath = oauthRouteUrlBuilder.buildCallbackUri(null).getPath();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Registering default callback route [GET: {}] for oauth configuration [{}]", (Object)defaultCallbackPath, (Object)name);
                            LOG.debug("Registering default callback route [POST: {}] for oauth configuration [{}]", (Object)defaultCallbackPath, (Object)name);
                        }
                        this.buildRoute(HttpMethod.GET, defaultCallbackPath, executionHandle);
                        this.buildRoute(HttpMethod.POST, defaultCallbackPath, executionHandle).consumes(new MediaType[]{MediaType.APPLICATION_FORM_URLENCODED_TYPE});
                    }
                });
                if (client instanceof OpenIdClient && ((OpenIdClient)client).supportsEndSession() && endSessionRegistered.compareAndSet(false, true)) {
                    beanContext.findExecutionHandle(EndSessionController.class, "endSession", new Class[]{HttpRequest.class, Authentication.class}).ifPresent(executionHandle -> {
                        String logoutUri = oauthConfiguration.getOpenid().getLogoutUri();
                        LoggingUtils.debug((Logger)LOG, (String)"Registering end session route [GET: {}]", (Object[])new Object[]{logoutUri});
                        this.buildRoute(HttpMethod.GET, logoutUri, (MethodExecutionHandle)executionHandle);
                    });
                }
            });
            if (!endSessionRegistered.get() && LOG.isDebugEnabled()) {
                LOG.debug("Skipped registration of logout route. No openid clients found that support end session");
            }
        }
    }
}

