/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.nonce.persistence.cookie;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.cookie.CookieConfiguration;
import io.micronaut.security.oauth2.endpoint.AbstractCookieConfiguration;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Optional;

@ConfigurationProperties(value="micronaut.security.oauth2.openid.nonce.cookie")
public class CookieNoncePersistenceConfiguration
extends AbstractCookieConfiguration
implements CookieConfiguration {
    public static final String PREFIX = "micronaut.security.oauth2.openid.nonce.cookie";
    private static final boolean DEFAULT_HTTPONLY = true;
    private static final String DEFAULT_COOKIENAME = "OPENID_NONCE";
    private static final String DEFAULT_COOKIEPATH = "/";
    private static final Duration DEFAULT_MAX_AGE = Duration.ofMinutes(5L);
    private String cookiePath = "/";
    private Boolean cookieHttpOnly = true;
    private Duration cookieMaxAge = DEFAULT_MAX_AGE;
    private String cookieName = "OPENID_NONCE";

    @NonNull
    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieName(@NonNull String cookieName) {
        this.cookieName = cookieName;
    }

    public Optional<String> getCookiePath() {
        return Optional.ofNullable(this.cookiePath);
    }

    public void setCookiePath(@Nullable String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public Optional<Boolean> isCookieHttpOnly() {
        return Optional.ofNullable(this.cookieHttpOnly);
    }

    public void setCookieHttpOnly(Boolean cookieHttpOnly) {
        this.cookieHttpOnly = cookieHttpOnly;
    }

    public Optional<TemporalAmount> getCookieMaxAge() {
        return Optional.ofNullable(this.cookieMaxAge);
    }

    public void setCookieMaxAge(Duration cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }
}

