/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client.condition;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.Named;
import io.micronaut.core.value.ValueResolver;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.EndpointConfiguration;
import io.micronaut.security.oauth2.grants.GrantType;
import java.util.Optional;

@Internal
public class OauthClientCondition
implements Condition {
    public boolean matches(ConditionContext context) {
        Optional optional;
        AnnotationMetadataProvider component = context.getComponent();
        BeanContext beanContext = context.getBeanContext();
        if (beanContext instanceof ApplicationContext && component instanceof ValueResolver && (optional = ((ValueResolver)component).get((CharSequence)Named.class.getName(), String.class)).isPresent()) {
            String name = (String)optional.get();
            OauthClientConfiguration clientConfiguration = (OauthClientConfiguration)beanContext.getBean(OauthClientConfiguration.class, Qualifiers.byName((String)name));
            String failureMsgPrefix = "Skipped client creation for provider [" + name;
            if (clientConfiguration.isEnabled()) {
                if (clientConfiguration.getAuthorization().flatMap(EndpointConfiguration::getUrl).isPresent()) {
                    if (clientConfiguration.getToken().flatMap(EndpointConfiguration::getUrl).isPresent()) {
                        if (clientConfiguration.getGrantType() == GrantType.AUTHORIZATION_CODE) {
                            return true;
                        }
                        context.fail(failureMsgPrefix + "] because grant type is not authorization code");
                    } else {
                        context.fail(failureMsgPrefix + "] because no token endpoint is configured");
                    }
                } else {
                    context.fail(failureMsgPrefix + "] because no authorization endpoint is configured");
                }
            } else {
                context.fail(failureMsgPrefix + "] because the configuration is disabled");
            }
            return false;
        }
        return true;
    }
}

