/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.endsession.request;

import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.endsession.request.AbstractEndSessionRequest;
import io.micronaut.security.oauth2.endpoint.endsession.response.EndSessionCallbackUrlBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class KeycloakEndSessionEndpoint
extends AbstractEndSessionRequest {
    private static final String PARAM_REDIRECT_URI = "redirect_uri";
    private static final String LOGOUT_URI = "/protocol/openid-connect/logout";

    public KeycloakEndSessionEndpoint(EndSessionCallbackUrlBuilder endSessionCallbackUrlBuilder, OauthClientConfiguration clientConfiguration, Supplier<OpenIdProviderMetadata> providerMetadata) {
        super(endSessionCallbackUrlBuilder, clientConfiguration, providerMetadata);
    }

    @Override
    protected String getUrl() {
        OpenIdProviderMetadata openIdProviderMetadata = (OpenIdProviderMetadata)this.providerMetadataSupplier.get();
        return openIdProviderMetadata.getEndSessionEndpoint() != null ? openIdProviderMetadata.getEndSessionEndpoint() : StringUtils.prependUri((String)openIdProviderMetadata.getIssuer(), (String)LOGOUT_URI);
    }

    @Override
    protected Map<String, Object> getArguments(HttpRequest<?> originating, Authentication authentication) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(PARAM_REDIRECT_URI, this.getRedirectUri(originating));
        return arguments;
    }
}

