/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization.state.validation;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.oauth2.endpoint.authorization.state.InvalidStateException;
import io.micronaut.security.oauth2.endpoint.authorization.state.State;
import io.micronaut.security.oauth2.endpoint.authorization.state.persistence.StatePersistence;
import io.micronaut.security.oauth2.endpoint.authorization.state.validation.StateValidator;
import jakarta.inject.Singleton;
import java.util.Optional;

@Singleton
public class DefaultStateValidator
implements StateValidator {
    private final StatePersistence statePersistence;

    public DefaultStateValidator(StatePersistence statePersistence) {
        this.statePersistence = statePersistence;
    }

    @Override
    public void validate(@NonNull HttpRequest<?> request, @Nullable State state) throws InvalidStateException {
        if (state == null) {
            throw new InvalidStateException("Provided state is null");
        }
        Optional<State> persistedState = this.statePersistence.retrieveState(request);
        if (!persistedState.isPresent()) {
            throw new InvalidStateException("Could not find the stored state");
        }
        if (!persistedState.get().equals(state)) {
            throw new InvalidStateException("State comparison failed");
        }
    }
}

