/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization.response;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.value.ConvertibleMultiValues;
import io.micronaut.core.convert.value.MutableConvertibleMultiValuesMap;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.oauth2.endpoint.authorization.response.AuthorizationResponse;
import io.micronaut.security.oauth2.endpoint.authorization.response.StateAwareAuthorizationCallback;
import io.micronaut.security.oauth2.endpoint.authorization.state.StateSerDes;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractAuthorizationResponse
extends StateAwareAuthorizationCallback
implements AuthorizationResponse {
    protected final ConvertibleMultiValues<String> responseData;
    protected final HttpRequest<Map<String, Object>> request;

    public AbstractAuthorizationResponse(@Parameter HttpRequest<Map<String, Object>> request, StateSerDes stateSerDes) {
        super(stateSerDes);
        this.responseData = request.getBody().map(body -> {
            MutableConvertibleMultiValuesMap map = new MutableConvertibleMultiValuesMap();
            body.forEach((key, value) -> map.add((CharSequence)key, (Object)value.toString()));
            return map;
        }).orElseGet(() -> request.getParameters());
        this.request = request;
    }

    @Override
    protected String getStateValue() {
        return (String)this.responseData.get((CharSequence)"state");
    }

    @Override
    @NonNull
    public String getCode() {
        return (String)Objects.requireNonNull(this.responseData.get((CharSequence)"code"));
    }

    @Override
    @NonNull
    public HttpRequest<?> getCallbackRequest() {
        return this.request;
    }
}

