/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization.response;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.security.config.RedirectConfiguration;
import io.micronaut.security.config.RedirectService;
import io.micronaut.security.oauth2.endpoint.authorization.response.AuthorizationErrorResponseException;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AuthorizationErrorResponseExceptionHandler
implements ExceptionHandler<AuthorizationErrorResponseException, MutableHttpResponse<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationErrorResponseExceptionHandler.class);
    @Nullable
    private final RedirectConfiguration redirectConfiguration;
    @Nullable
    private final RedirectService redirectService;
    @Nullable
    private final ErrorResponseProcessor<?> errorResponseProcessor;

    @Inject
    public AuthorizationErrorResponseExceptionHandler(@Nullable RedirectConfiguration redirectConfiguration, @Nullable RedirectService redirectService, @Nullable ErrorResponseProcessor<?> errorResponseProcessor) {
        this.redirectConfiguration = redirectConfiguration;
        this.redirectService = redirectService;
        this.errorResponseProcessor = errorResponseProcessor;
    }

    @Deprecated
    public AuthorizationErrorResponseExceptionHandler() {
        this(null, null, null);
    }

    public MutableHttpResponse<?> handle(HttpRequest request, AuthorizationErrorResponseException exception) {
        URI location;
        if (this.redirectConfiguration == null || this.redirectService == null || this.errorResponseProcessor == null) {
            return HttpResponse.badRequest((Object)exception.getAuthorizationErrorResponse());
        }
        if (!this.shouldRedirect(request, exception)) {
            return this.httpResponseWithStatus(request, exception);
        }
        try {
            location = new URI(this.getRedirectUri(request, exception));
        }
        catch (URISyntaxException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("redirect URL is invalid", (Throwable)e);
            }
            return HttpResponse.serverError();
        }
        return request.getUri().equals(location) ? this.httpResponseWithStatus(request, exception) : this.httpResponseWithStatus(location);
    }

    @NonNull
    protected MutableHttpResponse<?> httpResponseWithStatus(@NonNull URI location) {
        return HttpResponse.seeOther((URI)location);
    }

    @NonNull
    protected MutableHttpResponse<?> httpResponseWithStatus(@NonNull HttpRequest<?> request, @NonNull AuthorizationErrorResponseException exception) {
        return this.errorResponseProcessor.processResponse(ErrorContext.builder(request).cause((Throwable)exception).build(), HttpResponse.badRequest((Object)exception.getAuthorizationErrorResponse()));
    }

    @NonNull
    protected String getRedirectUri(@NonNull HttpRequest<?> request, @NonNull AuthorizationErrorResponseException exception) {
        String uri = this.redirectService.loginFailureUrl();
        if (LOG.isDebugEnabled()) {
            LOG.debug("redirect uri: {}", (Object)uri);
        }
        return uri;
    }

    protected boolean shouldRedirect(@NonNull HttpRequest<?> request, @NonNull AuthorizationErrorResponseException exception) {
        return this.redirectConfiguration != null && this.redirectConfiguration.isEnabled() && AuthorizationErrorResponseExceptionHandler.acceptsHtml(request);
    }

    private static boolean acceptsHtml(@NonNull HttpRequest<?> request) {
        return request.getHeaders().accept().stream().anyMatch(mediaType -> mediaType.equals((Object)MediaType.TEXT_HTML_TYPE));
    }
}

