/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.token.request;

import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.RxHttpClient;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.AuthenticationMethod;
import io.micronaut.security.oauth2.endpoint.token.request.TokenEndpointClient;
import io.micronaut.security.oauth2.endpoint.token.request.context.TokenRequestContext;
import io.micronaut.security.oauth2.endpoint.token.response.TokenResponse;
import io.micronaut.security.oauth2.grants.SecureGrant;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultTokenEndpointClient
implements TokenEndpointClient {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTokenEndpointClient.class);
    private final BeanContext beanContext;
    private final Supplier<RxHttpClient> defaultTokenClient;
    private final ConcurrentHashMap<String, RxHttpClient> tokenClients = new ConcurrentHashMap();

    public DefaultTokenEndpointClient(BeanContext beanContext, HttpClientConfiguration defaultClientConfiguration) {
        this.beanContext = beanContext;
        this.defaultTokenClient = SupplierUtil.memoized(() -> (RxHttpClient)beanContext.createBean(RxHttpClient.class, new Object[]{LoadBalancer.empty(), defaultClientConfiguration}));
    }

    @Override
    @NonNull
    public <G, R extends TokenResponse> Publisher<R> sendRequest(TokenRequestContext<G, R> requestContext) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Sending request to token endpoint [{}]", (Object)requestContext.getEndpoint().getUrl());
        }
        MutableHttpRequest request = HttpRequest.POST((String)requestContext.getEndpoint().getUrl(), requestContext.getGrant()).contentType(requestContext.getMediaType()).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        this.secureRequest(request, requestContext);
        return this.getClient(requestContext.getClientConfiguration().getName()).retrieve((HttpRequest)request, requestContext.getResponseType(), requestContext.getErrorResponseType());
    }

    protected <G, R extends TokenResponse> void secureRequest(@NonNull MutableHttpRequest<G> request, TokenRequestContext<G, R> requestContext) {
        List authMethodsSupported = requestContext.getEndpoint().getSupportedAuthenticationMethods().orElseGet(() -> Collections.singletonList(AuthenticationMethod.CLIENT_SECRET_BASIC));
        OauthClientConfiguration clientConfiguration = requestContext.getClientConfiguration();
        if (LOG.isTraceEnabled()) {
            LOG.trace("The token endpoint supports [{}] authentication methods", (Object)authMethodsSupported);
        }
        if (authMethodsSupported.contains((Object)AuthenticationMethod.CLIENT_SECRET_BASIC)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Using client_secret_basic authentication. Adding an Authorization header");
            }
            request.basicAuth((CharSequence)clientConfiguration.getClientId(), (CharSequence)clientConfiguration.getClientSecret());
        } else if (authMethodsSupported.contains((Object)AuthenticationMethod.CLIENT_SECRET_POST)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Using client_secret_post authentication. The client_id and client_secret will be present in the body");
            }
            request.getBody().filter(body -> body instanceof SecureGrant).map(SecureGrant.class::cast).ifPresent(body -> {
                body.setClientId(clientConfiguration.getClientId());
                body.setClientSecret(clientConfiguration.getClientSecret());
            });
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Unsupported or no authentication method. The client_id will be present in the body");
            }
            request.getBody().filter(body -> body instanceof SecureGrant).map(SecureGrant.class::cast).ifPresent(body -> body.setClientId(clientConfiguration.getClientId()));
        }
    }

    protected RxHttpClient getClient(String providerName) {
        return this.tokenClients.computeIfAbsent(providerName, provider -> {
            Optional client = this.beanContext.findBean(RxHttpClient.class, Qualifiers.byName((String)provider));
            return client.orElseGet(this.defaultTokenClient);
        });
    }
}

