/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.oauth2.ProviderResolver;
import io.micronaut.security.oauth2.configuration.OpenIdClientConfiguration;
import java.util.List;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class DefaultProviderResolver
implements ProviderResolver {
    private final List<OpenIdClientConfiguration> openIdClientConfigurations;

    public DefaultProviderResolver(List<OpenIdClientConfiguration> openIdClientConfigurations) {
        this.openIdClientConfigurations = openIdClientConfigurations;
    }

    @Override
    public Optional<String> resolveProvider(Authentication authentication) {
        Object providerKey = authentication.getAttributes().get("oauth2Provider");
        if (providerKey != null) {
            return Optional.of(providerKey.toString());
        }
        return this.openIdClientNameWhichMatchesIssClaim(authentication);
    }

    protected Optional<String> openIdClientNameWhichMatchesIssClaim(Authentication authentication) {
        Object issuer = authentication.getAttributes().get("iss");
        return issuer != null ? this.openIdClientNameWhichMatchesIssuer(issuer.toString()) : Optional.empty();
    }

    @NonNull
    protected Optional<String> openIdClientNameWhichMatchesIssuer(@NonNull String issuer) {
        for (OpenIdClientConfiguration conf : this.openIdClientConfigurations) {
            if (!conf.getIssuer().isPresent() || !conf.getIssuer().get().toString().startsWith(issuer)) continue;
            return Optional.of(conf.getName());
        }
        return Optional.empty();
    }
}

