/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization.request;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.configuration.OpenIdClientConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.AuthorizationEndpointConfiguration;
import io.micronaut.security.oauth2.endpoint.authorization.request.Display;
import io.micronaut.security.oauth2.endpoint.authorization.request.IdTokenHintResolver;
import io.micronaut.security.oauth2.endpoint.authorization.request.LoginHintResolver;
import io.micronaut.security.oauth2.endpoint.authorization.request.OpenIdAuthorizationRequest;
import io.micronaut.security.oauth2.endpoint.authorization.request.Prompt;
import io.micronaut.security.oauth2.endpoint.authorization.request.ResponseType;
import io.micronaut.security.oauth2.endpoint.authorization.state.StateFactory;
import io.micronaut.security.oauth2.endpoint.nonce.NonceFactory;
import io.micronaut.security.oauth2.url.OauthRouteUrlBuilder;
import java.util.List;
import java.util.Optional;

@Prototype
@Requires(configuration="io.micronaut.security.token.jwt")
@Internal
class DefaultOpenIdAuthorizationRequest
implements OpenIdAuthorizationRequest {
    private final HttpRequest<?> request;
    private OauthClientConfiguration oauthConfiguration;
    private final StateFactory stateFactory;
    private final NonceFactory nonceFactory;
    private LoginHintResolver loginHintResolver;
    private IdTokenHintResolver idTokenHintResolver;
    private AuthorizationEndpointConfiguration endpointConfiguration;
    private final OauthRouteUrlBuilder oauthRouteUrlBuilder;

    public DefaultOpenIdAuthorizationRequest(@Parameter HttpRequest<?> request, @Parameter OauthClientConfiguration oauthConfiguration, OauthRouteUrlBuilder oauthRouteUrlBuilder, @Nullable StateFactory stateFactory, @Nullable NonceFactory nonceFactory, @Nullable LoginHintResolver loginHintResolver, @Nullable IdTokenHintResolver idTokenHintResolver) {
        this.request = request;
        this.oauthConfiguration = oauthConfiguration;
        this.endpointConfiguration = oauthConfiguration.getOpenid().flatMap(OpenIdClientConfiguration::getAuthorization).orElse(null);
        this.oauthRouteUrlBuilder = oauthRouteUrlBuilder;
        this.stateFactory = stateFactory;
        this.nonceFactory = nonceFactory;
        this.loginHintResolver = loginHintResolver;
        this.idTokenHintResolver = idTokenHintResolver;
    }

    @Override
    @NonNull
    public String getClientId() {
        return this.oauthConfiguration.getClientId();
    }

    @Override
    public Optional<String> getState(MutableHttpResponse response) {
        return Optional.ofNullable(this.stateFactory).map(sf -> sf.buildState(this.request, response, this));
    }

    @Override
    @Nullable
    public Optional<String> getNonce(MutableHttpResponse response) {
        return Optional.ofNullable(this.nonceFactory).map(nf -> nf.buildNonce(this.request, response));
    }

    @Override
    @NonNull
    public List<String> getScopes() {
        return this.oauthConfiguration.getScopes();
    }

    @Override
    @NonNull
    public String getResponseType() {
        if (this.endpointConfiguration != null) {
            return this.endpointConfiguration.getResponseType().toString();
        }
        return ResponseType.CODE.toString();
    }

    @Override
    public Optional<String> getRedirectUri() {
        return Optional.of(this.oauthRouteUrlBuilder.buildCallbackUrl(this.request, this.oauthConfiguration.getName()).toString());
    }

    @Override
    public Optional<String> getResponseMode() {
        return Optional.ofNullable(this.endpointConfiguration).flatMap(AuthorizationEndpointConfiguration::getResponseMode);
    }

    @Override
    public Optional<Display> getDisplay() {
        return Optional.ofNullable(this.endpointConfiguration).flatMap(AuthorizationEndpointConfiguration::getDisplay);
    }

    @Override
    public Optional<Prompt> getPrompt() {
        return Optional.ofNullable(this.endpointConfiguration).flatMap(AuthorizationEndpointConfiguration::getPrompt);
    }

    @Override
    public Optional<Integer> getMaxAge() {
        return Optional.ofNullable(this.endpointConfiguration).flatMap(AuthorizationEndpointConfiguration::getMaxAge);
    }

    @Override
    public Optional<List<String>> getUiLocales() {
        return Optional.ofNullable(this.endpointConfiguration).flatMap(AuthorizationEndpointConfiguration::getUiLocales);
    }

    @Override
    public Optional<String> getIdTokenHint() {
        return Optional.ofNullable(this.idTokenHintResolver).map(resolver -> resolver.resolve(this.request));
    }

    @Override
    public Optional<String> getLoginHint() {
        return Optional.ofNullable(this.loginHintResolver).map(resolver -> resolver.resolve(this.request));
    }

    @Override
    public Optional<List<String>> getAcrValues() {
        return Optional.ofNullable(this.endpointConfiguration).flatMap(AuthorizationEndpointConfiguration::getAcrValues);
    }
}

