/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.configuration;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.util.Toggleable;
import io.micronaut.security.oauth2.client.clientcredentials.ClientCredentialsConfiguration;
import io.micronaut.security.oauth2.configuration.OpenIdClientConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.EndpointConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.SecureEndpointConfiguration;
import io.micronaut.security.oauth2.endpoint.AuthenticationMethod;
import io.micronaut.security.oauth2.endpoint.DefaultSecureEndpoint;
import io.micronaut.security.oauth2.endpoint.SecureEndpoint;
import io.micronaut.security.oauth2.grants.GrantType;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public interface OauthClientConfiguration
extends Toggleable {
    public static final AuthenticationMethod DEFAULT_AUTHENTICATION_METHOD = AuthenticationMethod.CLIENT_SECRET_POST;
    public static final Duration DEFAULT_ADVANCED_EXPIRATION = Duration.ofSeconds(30L);

    @NonNull
    public String getName();

    @NonNull
    public String getClientId();

    @Nullable
    public String getClientSecret();

    @NonNull
    public List<String> getScopes();

    @NonNull
    public GrantType getGrantType();

    public Optional<SecureEndpointConfiguration> getToken();

    public Optional<EndpointConfiguration> getAuthorization();

    @NonNull
    default public Optional<ClientCredentialsConfiguration> getClientCredentials() {
        return Optional.empty();
    }

    public Optional<SecureEndpointConfiguration> getIntrospection();

    public Optional<SecureEndpointConfiguration> getRevocation();

    public Optional<OpenIdClientConfiguration> getOpenid();

    default public SecureEndpoint getTokenEndpoint() throws ConfigurationException {
        Optional<SecureEndpointConfiguration> tokenOptional = this.getToken();
        return new DefaultSecureEndpoint((String)tokenOptional.flatMap(EndpointConfiguration::getUrl).orElseThrow(() -> new ConfigurationException("Oauth client requires the token endpoint URL to be set in configuration")), Collections.singletonList(tokenOptional.flatMap(SecureEndpointConfiguration::getAuthMethod).orElse(DEFAULT_AUTHENTICATION_METHOD)));
    }
}

