/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.token.response;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.security.oauth2.endpoint.token.response.TokenResponse;
import java.util.Calendar;
import java.util.Date;

@Introspected
public class TokenResponseExpiration
extends TokenResponse {
    @Nullable
    private Date expiration;

    public TokenResponseExpiration(TokenResponse tokenResponse) {
        this.setAccessToken(tokenResponse.getAccessToken());
        this.setRefreshToken(tokenResponse.getRefreshToken());
        this.setExpiresIn(tokenResponse.getExpiresIn());
        this.setScope(tokenResponse.getScope());
        this.setTokenType(tokenResponse.getTokenType());
    }

    @Override
    public void setExpiresIn(Integer expiresIn) {
        super.setExpiresIn(expiresIn);
        if (expiresIn != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(13, expiresIn);
            this.expiration = calendar.getTime();
        }
    }

    @Nullable
    public Date getExpiration() {
        return this.expiration;
    }
}

