/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.configuration;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.http.MediaType;
import io.micronaut.security.oauth2.client.clientcredentials.ClientCredentialsConfiguration;
import io.micronaut.security.oauth2.client.clientcredentials.propagation.ClientCredentialsHeaderTokenPropagatorConfiguration;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.configuration.OpenIdClientConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.AuthorizationEndpointConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.DefaultEndpointConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.DefaultSecureEndpointConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.EndSessionEndpointConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.EndpointConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.IntrospectionEndpointConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.RevocationEndpointConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.SecureEndpointConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.TokenEndpointConfiguration;
import io.micronaut.security.oauth2.endpoint.authorization.request.Display;
import io.micronaut.security.oauth2.endpoint.authorization.request.OpenIdScope;
import io.micronaut.security.oauth2.endpoint.authorization.request.Prompt;
import io.micronaut.security.oauth2.endpoint.authorization.request.ResponseType;
import io.micronaut.security.oauth2.grants.GrantType;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;

@Context
@EachProperty(value="micronaut.security.oauth2.clients")
public class OauthClientConfigurationProperties
implements OauthClientConfiguration {
    public static final boolean DEFAULT_ENABLED = true;
    private List<String> DEFAULT_SCOPES = new ArrayList<String>();
    private final String name;
    private String clientId;
    private String clientSecret;
    private List<String> scopes;
    private boolean enabled = true;
    private GrantType grantType = GrantType.AUTHORIZATION_CODE;
    private AuthorizationEndpointConfigurationProperties authorization;
    private TokenEndpointConfigurationProperties token;
    private IntrospectionEndpointConfigurationProperties introspection;
    private RevocationEndpointConfigurationProperties revocation;
    private OpenIdClientConfigurationProperties openid;
    private ClientCredentialsConfigurationProperties clientCredentials;

    public OauthClientConfigurationProperties(@Parameter String name) {
        this.name = name;
    }

    @Override
    @NonNull
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(@NonNull String clientId) {
        this.clientId = clientId;
    }

    @Override
    @Nullable
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(@Nullable String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    @NonNull
    public List<String> getScopes() {
        return this.scopes == null ? this.DEFAULT_SCOPES : this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    @NonNull
    public GrantType getGrantType() {
        return this.grantType;
    }

    public void setGrantType(@NonNull GrantType grantType) {
        this.grantType = grantType;
    }

    @Override
    public Optional<SecureEndpointConfiguration> getToken() {
        return Optional.ofNullable(this.token);
    }

    public void setToken(TokenEndpointConfigurationProperties token) {
        this.token = token;
    }

    @Override
    public Optional<EndpointConfiguration> getAuthorization() {
        return Optional.ofNullable(this.authorization);
    }

    @Override
    @NonNull
    public Optional<ClientCredentialsConfiguration> getClientCredentials() {
        return Optional.ofNullable(this.clientCredentials);
    }

    public void setClientCredentials(@NonNull ClientCredentialsConfigurationProperties clientCredentials) {
        this.clientCredentials = clientCredentials;
    }

    public void setAuthorization(AuthorizationEndpointConfigurationProperties authorization) {
        this.authorization = authorization;
    }

    @Override
    public Optional<OpenIdClientConfiguration> getOpenid() {
        return Optional.ofNullable(this.openid);
    }

    public void setOpenid(OpenIdClientConfigurationProperties openid) {
        this.openid = openid;
        this.DEFAULT_SCOPES = Arrays.asList(OpenIdScope.OPENID.toString(), OpenIdScope.EMAIL.toString(), OpenIdScope.PROFILE.toString());
    }

    @Override
    public Optional<SecureEndpointConfiguration> getIntrospection() {
        return Optional.ofNullable(this.introspection);
    }

    public void setIntrospection(IntrospectionEndpointConfigurationProperties introspection) {
        this.introspection = introspection;
    }

    @Override
    public Optional<SecureEndpointConfiguration> getRevocation() {
        return Optional.ofNullable(this.revocation);
    }

    public void setRevocation(RevocationEndpointConfigurationProperties revocation) {
        this.revocation = revocation;
    }

    @ConfigurationProperties(value="openid")
    public static class OpenIdClientConfigurationProperties
    implements OpenIdClientConfiguration {
        private static final String DEFAULT_CONFIG_PATH = "/.well-known/openid-configuration";
        private final String name;
        private URL issuer;
        private String configurationPath = "/.well-known/openid-configuration";
        private String jwksUri;
        private RegistrationEndpointConfigurationProperties registration;
        private UserInfoEndpointConfigurationProperties userInfo;
        private AuthorizationEndpointConfigurationProperties authorization;
        private TokenEndpointConfigurationProperties token;
        private EndSessionConfigurationProperties endSession = new EndSessionConfigurationProperties();

        OpenIdClientConfigurationProperties(@Parameter String name) {
            this.name = name;
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        @Override
        public Optional<URL> getIssuer() {
            return Optional.ofNullable(this.issuer);
        }

        public void setIssuer(@Nullable URL issuer) {
            this.issuer = issuer;
        }

        @Override
        @NonNull
        public String getConfigurationPath() {
            return this.configurationPath;
        }

        public void setConfigurationPath(@NonNull String configurationPath) {
            this.configurationPath = configurationPath;
        }

        @Override
        public Optional<String> getJwksUri() {
            return Optional.ofNullable(this.jwksUri);
        }

        public void setJwksUri(String jwksUri) {
            this.jwksUri = jwksUri;
        }

        @Override
        public Optional<EndpointConfiguration> getRegistration() {
            return Optional.ofNullable(this.registration);
        }

        public void setRegistration(RegistrationEndpointConfigurationProperties registration) {
            this.registration = registration;
        }

        @Override
        public Optional<EndpointConfiguration> getUserInfo() {
            return Optional.ofNullable(this.userInfo);
        }

        public void setUserInfo(UserInfoEndpointConfigurationProperties userInfo) {
            this.userInfo = userInfo;
        }

        @Override
        public Optional<AuthorizationEndpointConfiguration> getAuthorization() {
            return Optional.ofNullable(this.authorization);
        }

        public void setAuthorization(AuthorizationEndpointConfigurationProperties authorization) {
            this.authorization = authorization;
        }

        @Override
        public Optional<TokenEndpointConfiguration> getToken() {
            return Optional.ofNullable(this.token);
        }

        public void setToken(TokenEndpointConfigurationProperties token) {
            this.token = token;
        }

        @Override
        @NonNull
        public EndSessionEndpointConfiguration getEndSession() {
            return this.endSession;
        }

        public void setEndSession(@NonNull EndSessionConfigurationProperties endSession) {
            this.endSession = endSession;
        }

        @ConfigurationProperties(value="end-session")
        public static class EndSessionConfigurationProperties
        extends DefaultEndpointConfiguration
        implements EndSessionEndpointConfiguration {
            private static final boolean DEFAULT_ENABLED = true;
            private boolean enabled = true;

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        }

        @ConfigurationProperties(value="token")
        public static class TokenEndpointConfigurationProperties
        extends DefaultSecureEndpointConfiguration
        implements TokenEndpointConfiguration {
            private static final MediaType DEFAULT_CONTENT_TYPE = MediaType.APPLICATION_FORM_URLENCODED_TYPE;
            private MediaType contentType = DEFAULT_CONTENT_TYPE;

            @Override
            @NonNull
            public MediaType getContentType() {
                return this.contentType;
            }

            public void setContentType(@NonNull MediaType contentType) {
                this.contentType = contentType;
            }
        }

        @ConfigurationProperties(value="authorization")
        public static class AuthorizationEndpointConfigurationProperties
        extends DefaultEndpointConfiguration
        implements AuthorizationEndpointConfiguration {
            private ResponseType responseType = ResponseType.CODE;
            private String responseMode;
            private Display display;
            private Prompt prompt;
            private Integer maxAge;
            private List<String> uiLocales;
            private List<String> acrValues;

            @Override
            @NonNull
            public ResponseType getResponseType() {
                return this.responseType;
            }

            public void setResponseType(@NonNull ResponseType responseType) {
                this.responseType = responseType;
            }

            @Override
            public Optional<String> getResponseMode() {
                return Optional.ofNullable(this.responseMode);
            }

            public void setResponseMode(@Nullable String responseMode) {
                this.responseMode = responseMode;
            }

            @Override
            public Optional<Display> getDisplay() {
                return Optional.ofNullable(this.display);
            }

            public void setDisplay(@Nullable Display display) {
                this.display = display;
            }

            @Override
            public Optional<Prompt> getPrompt() {
                return Optional.ofNullable(this.prompt);
            }

            public void setPrompt(@Nullable Prompt prompt) {
                this.prompt = prompt;
            }

            @Override
            public Optional<Integer> getMaxAge() {
                return Optional.ofNullable(this.maxAge);
            }

            public void setMaxAge(@Nullable Integer maxAge) {
                this.maxAge = maxAge;
            }

            @Override
            public Optional<List<String>> getUiLocales() {
                return Optional.ofNullable(this.uiLocales);
            }

            public void setUiLocales(@Nullable List<String> uiLocales) {
                this.uiLocales = uiLocales;
            }

            @Override
            public Optional<List<String>> getAcrValues() {
                return Optional.ofNullable(this.acrValues);
            }

            public void setAcrValues(@Nullable List<String> acrValues) {
                this.acrValues = acrValues;
            }
        }

        @ConfigurationProperties(value="user-info")
        public static class UserInfoEndpointConfigurationProperties
        extends DefaultEndpointConfiguration {
        }

        @ConfigurationProperties(value="registration")
        public static class RegistrationEndpointConfigurationProperties
        extends DefaultEndpointConfiguration {
        }
    }

    @ConfigurationProperties(value="revocation")
    public static class RevocationEndpointConfigurationProperties
    extends DefaultSecureEndpointConfiguration
    implements RevocationEndpointConfiguration {
    }

    @ConfigurationProperties(value="introspection")
    public static class IntrospectionEndpointConfigurationProperties
    extends DefaultSecureEndpointConfiguration
    implements IntrospectionEndpointConfiguration {
    }

    @ConfigurationProperties(value="token")
    public static class TokenEndpointConfigurationProperties
    extends DefaultSecureEndpointConfiguration {
    }

    @ConfigurationProperties(value="authorization")
    public static class AuthorizationEndpointConfigurationProperties
    extends DefaultEndpointConfiguration {
    }

    @ConfigurationProperties(value="client-credentials")
    public static class ClientCredentialsConfigurationProperties
    implements ClientCredentialsConfiguration {
        public static final boolean DEFAULT_ENABLED = true;
        private boolean enabled = true;
        private String serviceIdRegex;
        private String uriRegex;
        private Pattern serviceIdPattern;
        private Pattern uriPattern;
        private String scope;
        private Duration advancedExpiration = OauthClientConfiguration.DEFAULT_ADVANCED_EXPIRATION;
        private HeaderTokenPropagatorConfigurationProperties headerPropagation;

        @Override
        @NonNull
        public Duration getAdvancedExpiration() {
            return this.advancedExpiration;
        }

        @Override
        @NonNull
        public Optional<ClientCredentialsHeaderTokenPropagatorConfiguration> getHeaderPropagation() {
            return Optional.ofNullable(this.headerPropagation);
        }

        public void setHeaderPropagation(@NonNull HeaderTokenPropagatorConfigurationProperties headerPropagation) {
            this.headerPropagation = headerPropagation;
        }

        public void setAdvancedExpiration(@NonNull Duration advancedExpiration) {
            this.advancedExpiration = advancedExpiration;
        }

        public String getServiceIdRegex() {
            return this.serviceIdRegex;
        }

        public void setServiceIdRegex(String serviceIdRegex) {
            this.serviceIdRegex = serviceIdRegex;
        }

        public String getUriRegex() {
            return this.uriRegex;
        }

        public void setUriRegex(String uriRegex) {
            this.uriRegex = uriRegex;
        }

        public Pattern getServiceIdPattern() {
            if (this.serviceIdPattern == null && this.serviceIdRegex != null) {
                this.serviceIdPattern = Pattern.compile(this.serviceIdRegex);
            }
            return this.serviceIdPattern;
        }

        public Pattern getUriPattern() {
            if (this.uriPattern == null && this.uriRegex != null) {
                this.uriPattern = Pattern.compile(this.uriRegex);
            }
            return this.uriPattern;
        }

        @Override
        @NonNull
        public Optional<String> getScope() {
            return Optional.ofNullable(this.scope);
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @ConfigurationProperties(value="header-propagation")
        public static class HeaderTokenPropagatorConfigurationProperties
        implements ClientCredentialsHeaderTokenPropagatorConfiguration {
            private String prefix = "Bearer";
            private String headerName = "Authorization";
            private boolean enabled = true;

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }

            public void setPrefix(String prefix) {
                this.prefix = prefix;
            }

            @Override
            public String getPrefix() {
                return this.prefix;
            }

            public void setHeaderName(String headerName) {
                this.headerName = headerName;
            }

            @Override
            public String getHeaderName() {
                return this.headerName;
            }
        }
    }
}

