/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client.clientcredentials;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.annotation.Internal;
import io.micronaut.security.oauth2.client.clientcredentials.CacheableProcessor;
import io.micronaut.security.oauth2.client.clientcredentials.ClientCredentialsClient;
import io.micronaut.security.oauth2.client.clientcredentials.ClientCredentialsConfiguration;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.token.request.TokenEndpointClient;
import io.micronaut.security.oauth2.endpoint.token.request.context.ClientCredentialsTokenRequestContext;
import io.micronaut.security.oauth2.endpoint.token.response.TokenResponse;
import io.micronaut.security.oauth2.endpoint.token.response.TokenResponseExpiration;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class AbstractClientCredentialsClient
implements ClientCredentialsClient {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractClientCredentialsClient.class);
    private static final String NOSCOPE = "NOSCOPE";
    protected final TokenEndpointClient tokenEndpointClient;
    protected final OauthClientConfiguration oauthClientConfiguration;
    protected final Map<String, CacheableProcessor<TokenResponse>> scopeToPublisherMap = new ConcurrentHashMap<String, CacheableProcessor<TokenResponse>>();

    public AbstractClientCredentialsClient(@NonNull OauthClientConfiguration oauthClientConfiguration, @NonNull TokenEndpointClient tokenEndpointClient) {
        this.oauthClientConfiguration = oauthClientConfiguration;
        this.tokenEndpointClient = tokenEndpointClient;
    }

    public String getName() {
        return this.oauthClientConfiguration.getName();
    }

    @Override
    @NonNull
    public Publisher<TokenResponse> requestToken(@Nullable String scope) {
        return this.requestToken(scope, false);
    }

    @Override
    @NonNull
    public Publisher<TokenResponse> requestToken(@Nullable String scope, boolean force) {
        String resolvedScope = scope != null ? scope : NOSCOPE;
        CacheableProcessor publisher = this.scopeToPublisherMap.computeIfAbsent(resolvedScope, key -> new CacheableProcessor<TokenResponse>(TokenResponseExpiration::new));
        if (force || this.isExpired((TokenResponse)publisher.getElement())) {
            publisher.clear();
        }
        if (publisher.getSubscription() == null) {
            ClientCredentialsTokenRequestContext context = this.createTokenRequestContext(scope);
            this.tokenEndpointClient.sendRequest(context).subscribe((Subscriber)publisher);
        }
        return publisher;
    }

    protected boolean isExpired(@Nullable TokenResponse tokenResponse) {
        if (tokenResponse == null) {
            return true;
        }
        return this.expirationDate(tokenResponse).map(expDate -> {
            boolean isExpired;
            Date now = new Date();
            long expTime = expDate.getTime();
            boolean bl = isExpired = (expTime -= this.oauthClientConfiguration.getClientCredentials().map(ClientCredentialsConfiguration::getAdvancedExpiration).orElse(OauthClientConfiguration.DEFAULT_ADVANCED_EXPIRATION).toMillis()) < now.getTime();
            if (isExpired && LOG.isTraceEnabled()) {
                LOG.trace("token: {} is expired" + tokenResponse.getAccessToken());
            }
            return isExpired;
        }).orElse(true);
    }

    protected Optional<Date> expirationDate(@NonNull TokenResponse tokenResponse) {
        try {
            JWT jwt = JWTParser.parse((String)tokenResponse.getAccessToken());
            return Optional.ofNullable(jwt.getJWTClaimsSet().getExpirationTime());
        }
        catch (ParseException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("cannot parse access token {} to JWT", (Object)tokenResponse.getAccessToken());
            }
            if (tokenResponse instanceof TokenResponseExpiration) {
                TokenResponseExpiration tokenResponseExpiration = (TokenResponseExpiration)tokenResponse;
                return Optional.ofNullable(tokenResponseExpiration.getExpiration());
            }
            return Optional.empty();
        }
    }

    protected abstract ClientCredentialsTokenRequestContext createTokenRequestContext(@Nullable String var1);
}

