/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization.response;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.convert.value.ConvertibleMultiValues;
import io.micronaut.core.convert.value.MutableConvertibleMultiValuesMap;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.errors.ErrorCode;
import io.micronaut.security.oauth2.endpoint.authorization.response.AuthorizationErrorCode;
import io.micronaut.security.oauth2.endpoint.authorization.response.AuthorizationErrorResponse;
import io.micronaut.security.oauth2.endpoint.authorization.response.StateAwareAuthorizationCallback;
import io.micronaut.security.oauth2.endpoint.authorization.state.StateSerDes;
import java.util.Locale;
import java.util.Map;

@Prototype
public class DefaultAuthorizationErrorResponse
extends StateAwareAuthorizationCallback
implements AuthorizationErrorResponse {
    private final ConvertibleMultiValues<String> responseData;

    public DefaultAuthorizationErrorResponse(@Parameter HttpRequest<Map<String, Object>> request, StateSerDes stateSerDes) {
        super(stateSerDes);
        this.responseData = request.getBody().map(body -> {
            MutableConvertibleMultiValuesMap map = new MutableConvertibleMultiValuesMap();
            body.forEach((key, value) -> map.add((CharSequence)key, (Object)value.toString()));
            return map;
        }).orElseGet(() -> request.getParameters());
    }

    @NonNull
    public ErrorCode getError() {
        String name = ((String)this.responseData.get((CharSequence)"error")).toUpperCase(Locale.ENGLISH);
        return AuthorizationErrorCode.valueOf(name);
    }

    @Nullable
    public String getErrorDescription() {
        return (String)this.responseData.get((CharSequence)"error_description");
    }

    @Override
    @Nullable
    public String getStateValue() {
        return (String)this.responseData.get((CharSequence)"state");
    }

    @Nullable
    public String getErrorUri() {
        return (String)this.responseData.get((CharSequence)"error_uri");
    }
}

