/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.BeanContext;
import io.micronaut.core.async.SupplierUtil;
import io.micronaut.core.convert.value.ConvertibleMultiValues;
import io.micronaut.core.convert.value.MutableConvertibleMultiValuesMap;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.oauth2.client.OpenIdClient;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.AuthenticationMethod;
import io.micronaut.security.oauth2.endpoint.DefaultSecureEndpoint;
import io.micronaut.security.oauth2.endpoint.SecureEndpoint;
import io.micronaut.security.oauth2.endpoint.authorization.request.AuthorizationRedirectHandler;
import io.micronaut.security.oauth2.endpoint.authorization.request.AuthorizationRequest;
import io.micronaut.security.oauth2.endpoint.authorization.request.OpenIdAuthorizationRequest;
import io.micronaut.security.oauth2.endpoint.authorization.response.AuthorizationErrorResponse;
import io.micronaut.security.oauth2.endpoint.authorization.response.AuthorizationErrorResponseException;
import io.micronaut.security.oauth2.endpoint.authorization.response.OpenIdAuthorizationResponse;
import io.micronaut.security.oauth2.endpoint.authorization.response.OpenIdAuthorizationResponseHandler;
import io.micronaut.security.oauth2.endpoint.endsession.request.EndSessionEndpoint;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdUserDetailsMapper;
import io.reactivex.Flowable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOpenIdClient
implements OpenIdClient {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOpenIdClient.class);
    private final OauthClientConfiguration clientConfiguration;
    private final Supplier<OpenIdProviderMetadata> openIdProviderMetadata;
    private final OpenIdUserDetailsMapper userDetailsMapper;
    private final AuthorizationRedirectHandler redirectUrlBuilder;
    private final OpenIdAuthorizationResponseHandler authorizationResponseHandler;
    private final Supplier<SecureEndpoint> tokenEndpoint;
    private final BeanContext beanContext;
    private final EndSessionEndpoint endSessionEndpoint;

    public DefaultOpenIdClient(OauthClientConfiguration clientConfiguration, Supplier<OpenIdProviderMetadata> openIdProviderMetadata, @Nullable OpenIdUserDetailsMapper userDetailsMapper, AuthorizationRedirectHandler redirectUrlBuilder, OpenIdAuthorizationResponseHandler authorizationResponseHandler, BeanContext beanContext, @Nullable EndSessionEndpoint endSessionEndpoint) {
        this.clientConfiguration = clientConfiguration;
        this.openIdProviderMetadata = openIdProviderMetadata;
        this.userDetailsMapper = userDetailsMapper;
        this.redirectUrlBuilder = redirectUrlBuilder;
        this.authorizationResponseHandler = authorizationResponseHandler;
        this.beanContext = beanContext;
        this.endSessionEndpoint = endSessionEndpoint;
        this.tokenEndpoint = SupplierUtil.memoized(this::getTokenEndpoint);
    }

    @Override
    public String getName() {
        return this.clientConfiguration.getName();
    }

    @Override
    public boolean supportsEndSession() {
        return this.endSessionEndpoint != null;
    }

    @Override
    public Optional<MutableHttpResponse<?>> endSessionRedirect(HttpRequest<?> request, Authentication authentication) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Starting end session flow to provider [{}]", (Object)this.getName());
        }
        return Optional.ofNullable(this.endSessionEndpoint).map(esr -> esr.getUrl(request, authentication)).map(url -> HttpResponse.status((HttpStatus)HttpStatus.FOUND).header((CharSequence)"Location", (CharSequence)url));
    }

    @Override
    public Publisher<MutableHttpResponse<?>> authorizationRedirect(HttpRequest<?> originating) {
        AuthorizationRequest authorizationRequest = (AuthorizationRequest)this.beanContext.createBean(OpenIdAuthorizationRequest.class, new Object[]{originating, this.clientConfiguration});
        String endpoint = this.openIdProviderMetadata.get().getAuthorizationEndpoint();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Starting authorization code grant flow to provider [{}]. Redirecting to [{}]", (Object)this.getName(), (Object)endpoint);
        }
        return Flowable.just(this.redirectUrlBuilder.redirect(authorizationRequest, endpoint));
    }

    @Override
    public Publisher<AuthenticationResponse> onCallback(HttpRequest<Map<String, Object>> request) {
        ConvertibleMultiValues responseData = request.getBody().map(body -> {
            MutableConvertibleMultiValuesMap map = new MutableConvertibleMultiValuesMap();
            body.forEach((key, value) -> map.add((CharSequence)key, (Object)value.toString()));
            return map;
        }).orElseGet(() -> request.getParameters());
        if (this.isErrorCallback((ConvertibleMultiValues<String>)responseData)) {
            AuthorizationErrorResponse errorResponse = (AuthorizationErrorResponse)this.beanContext.createBean(AuthorizationErrorResponse.class, new Object[]{request});
            if (LOG.isTraceEnabled()) {
                LOG.trace("Received an authorization error response from provider [{}]. Error: [{}]", (Object)this.getName(), (Object)errorResponse.getError());
            }
            throw new AuthorizationErrorResponseException(errorResponse);
        }
        OpenIdAuthorizationResponse authorizationResponse = (OpenIdAuthorizationResponse)this.beanContext.createBean(OpenIdAuthorizationResponse.class, new Object[]{request});
        if (LOG.isTraceEnabled()) {
            LOG.trace("Received a successful authorization response from provider [{}]", (Object)this.getName());
        }
        return this.authorizationResponseHandler.handle(authorizationResponse, this.clientConfiguration, this.openIdProviderMetadata.get(), this.userDetailsMapper, this.tokenEndpoint.get());
    }

    protected boolean isErrorCallback(ConvertibleMultiValues<String> responseData) {
        return responseData.contains("error");
    }

    protected SecureEndpoint getTokenEndpoint() {
        List<String> authMethodsSupported = this.openIdProviderMetadata.get().getTokenEndpointAuthMethodsSupported();
        List authenticationMethods = null;
        if (authMethodsSupported != null) {
            authenticationMethods = authMethodsSupported.stream().map(String::toUpperCase).map(AuthenticationMethod::valueOf).collect(Collectors.toList());
        }
        return new DefaultSecureEndpoint(this.openIdProviderMetadata.get().getTokenEndpoint(), authenticationMethods);
    }
}

