/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.token.response.validation;

import io.micronaut.context.annotation.Requires;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdClaims;
import io.micronaut.security.oauth2.endpoint.token.response.validation.OpenIdClaimsValidator;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(property="micronaut.security.oauth2.openid.claims-validation.issuer", notEquals="false")
@Singleton
public class IssuerClaimValidator
implements OpenIdClaimsValidator {
    private static final Logger LOG = LoggerFactory.getLogger(IssuerClaimValidator.class);

    @Override
    public boolean validate(OpenIdClaims claims, OauthClientConfiguration clientConfiguration, OpenIdProviderMetadata providerMetadata) {
        String issuer = claims.getIssuer();
        if (issuer == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("issuer claim does not exist");
            }
            return false;
        }
        boolean condition = issuer.equals(providerMetadata.getIssuer());
        if (!condition && LOG.isDebugEnabled()) {
            LOG.debug("JWT issuer claim does not match {}", (Object)providerMetadata.getIssuer());
        }
        return condition;
    }
}

