/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.token.response.validation;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.token.response.JWTOpenIdClaims;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdTokenResponse;
import io.micronaut.security.oauth2.endpoint.token.response.validation.NonceClaimValidator;
import io.micronaut.security.oauth2.endpoint.token.response.validation.OpenIdClaimsValidator;
import io.micronaut.security.oauth2.endpoint.token.response.validation.OpenIdTokenResponseValidator;
import io.micronaut.security.token.jwt.generator.claims.JwtClaims;
import io.micronaut.security.token.jwt.signature.SignatureConfiguration;
import io.micronaut.security.token.jwt.signature.jwks.JwkValidator;
import io.micronaut.security.token.jwt.signature.jwks.JwksSignature;
import io.micronaut.security.token.jwt.validator.GenericJwtClaimsValidator;
import io.micronaut.security.token.jwt.validator.JwtValidator;
import java.text.ParseException;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultOpenIdTokenResponseValidator
implements OpenIdTokenResponseValidator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOpenIdTokenResponseValidator.class);
    private final Collection<OpenIdClaimsValidator> openIdClaimsValidators;
    private final Collection<GenericJwtClaimsValidator> genericJwtClaimsValidators;
    private final NonceClaimValidator nonceClaimValidator;
    private final JwkValidator jwkValidator;

    public DefaultOpenIdTokenResponseValidator(Collection<OpenIdClaimsValidator> idTokenValidators, Collection<GenericJwtClaimsValidator> genericJwtClaimsValidators, NonceClaimValidator nonceClaimValidator, JwkValidator jwkValidator) {
        this.openIdClaimsValidators = idTokenValidators;
        this.genericJwtClaimsValidators = genericJwtClaimsValidators;
        this.nonceClaimValidator = nonceClaimValidator;
        this.jwkValidator = jwkValidator;
    }

    @Override
    public Optional<JWT> validate(OauthClientConfiguration clientConfiguration, OpenIdProviderMetadata openIdProviderMetadata, OpenIdTokenResponse openIdTokenResponse, @Nullable String nonce) {
        block14: {
            Optional jwt;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Validating the JWT signature using the JWKS uri [{}]", (Object)openIdProviderMetadata.getJwksUri());
            }
            if ((jwt = JwtValidator.builder().withSignatures(new SignatureConfiguration[]{new JwksSignature(openIdProviderMetadata.getJwksUri(), null, this.jwkValidator)}).build().validate(openIdTokenResponse.getIdToken())).isPresent()) {
                try {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("JWT signature validation succeeded. Validating claims...");
                    }
                    JWTClaimsSet claimsSet = ((JWT)jwt.get()).getJWTClaimsSet();
                    JWTOpenIdClaims claims = new JWTOpenIdClaims(claimsSet);
                    if (this.genericJwtClaimsValidators.stream().allMatch(validator -> validator.validate((JwtClaims)claims))) {
                        if (this.openIdClaimsValidators.stream().allMatch(validator -> validator.validate(claims, clientConfiguration, openIdProviderMetadata))) {
                            if (this.nonceClaimValidator.validate(claims, clientConfiguration, openIdProviderMetadata, nonce)) {
                                return jwt;
                            }
                        } else if (LOG.isErrorEnabled()) {
                            LOG.error("JWT OpenID specific claims validation failed for provider [{}]", (Object)clientConfiguration.getName());
                        }
                    } else if (LOG.isErrorEnabled()) {
                        LOG.error("JWT generic claims validation failed for provider [{}]", (Object)clientConfiguration.getName());
                    }
                    break block14;
                }
                catch (ParseException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error("Failed to parse the JWT returned from provider [{}]", (Object)clientConfiguration.getName(), (Object)e);
                    }
                    break block14;
                }
            }
            if (LOG.isErrorEnabled()) {
                LOG.error("JWT signature validation failed for provider [{}]", (Object)clientConfiguration.getName());
            }
        }
        return Optional.empty();
    }
}

