/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.token.response;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.Requires;
import io.micronaut.security.authentication.AuthenticationMode;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.authentication.UserDetails;
import io.micronaut.security.config.AuthenticationModeConfiguration;
import io.micronaut.security.oauth2.configuration.OpenIdAdditionalClaimsConfiguration;
import io.micronaut.security.oauth2.endpoint.authorization.state.State;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdClaims;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdTokenResponse;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdUserDetailsMapper;
import io.micronaut.security.token.jwt.generator.claims.JwtClaims;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@Requires(configuration="io.micronaut.security.token.jwt")
public class DefaultOpenIdUserDetailsMapper
implements OpenIdUserDetailsMapper {
    private final OpenIdAdditionalClaimsConfiguration openIdAdditionalClaimsConfiguration;
    private final AuthenticationModeConfiguration authenticationModeConfiguration;

    @Inject
    public DefaultOpenIdUserDetailsMapper(OpenIdAdditionalClaimsConfiguration openIdAdditionalClaimsConfiguration, AuthenticationModeConfiguration authenticationModeConfiguration) {
        this.openIdAdditionalClaimsConfiguration = openIdAdditionalClaimsConfiguration;
        this.authenticationModeConfiguration = authenticationModeConfiguration;
    }

    @Deprecated
    public DefaultOpenIdUserDetailsMapper(OpenIdAdditionalClaimsConfiguration openIdAdditionalClaimsConfiguration) {
        this(openIdAdditionalClaimsConfiguration, null);
    }

    @Override
    @NonNull
    public UserDetails createUserDetails(String providerName, OpenIdTokenResponse tokenResponse, OpenIdClaims openIdClaims) {
        Map<String, Object> claims = this.buildAttributes(providerName, tokenResponse, openIdClaims);
        List<String> roles = this.getRoles(providerName, tokenResponse, openIdClaims);
        String username = this.getUsername(providerName, tokenResponse, openIdClaims);
        return new UserDetails(username, roles, claims);
    }

    @Override
    @NonNull
    public AuthenticationResponse createAuthenticationResponse(String providerName, OpenIdTokenResponse tokenResponse, OpenIdClaims openIdClaims, @Nullable State state) {
        return this.createUserDetails(providerName, tokenResponse, openIdClaims);
    }

    protected Map<String, Object> buildAttributes(String providerName, OpenIdTokenResponse tokenResponse, OpenIdClaims openIdClaims) {
        boolean idtokenAuthentication;
        HashMap<String, Object> claims = new HashMap<String, Object>(openIdClaims.getClaims());
        JwtClaims.ALL_CLAIMS.forEach(claims::remove);
        claims.put("oauth2Provider", providerName);
        boolean bl = idtokenAuthentication = this.authenticationModeConfiguration.getAuthentication() != null && this.authenticationModeConfiguration.getAuthentication() == AuthenticationMode.IDTOKEN;
        if (idtokenAuthentication || this.openIdAdditionalClaimsConfiguration.isJwt()) {
            claims.put("openIdToken", tokenResponse.getIdToken());
        }
        if (idtokenAuthentication || this.openIdAdditionalClaimsConfiguration.isAccessToken()) {
            claims.put("accessToken", tokenResponse.getAccessToken());
        }
        if (idtokenAuthentication || this.openIdAdditionalClaimsConfiguration.isRefreshToken() && tokenResponse.getRefreshToken() != null) {
            claims.put("refreshToken", tokenResponse.getRefreshToken());
        }
        return claims;
    }

    protected List<String> getRoles(String providerName, OpenIdTokenResponse tokenResponse, OpenIdClaims openIdClaims) {
        return Collections.emptyList();
    }

    protected String getUsername(String providerName, OpenIdTokenResponse tokenResponse, OpenIdClaims openIdClaims) {
        return openIdClaims.getSubject();
    }
}

