/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.token.request.password;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.Internal;
import io.micronaut.security.authentication.AuthenticationProvider;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.token.request.TokenEndpointClient;
import io.micronaut.security.oauth2.endpoint.token.request.password.OauthPasswordAuthenticationProvider;
import io.micronaut.security.oauth2.endpoint.token.request.password.OpenIdPasswordAuthenticationProvider;
import io.micronaut.security.oauth2.endpoint.token.response.DefaultOpenIdUserDetailsMapper;
import io.micronaut.security.oauth2.endpoint.token.response.OauthUserDetailsMapper;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdUserDetailsMapper;
import io.micronaut.security.oauth2.endpoint.token.response.validation.OpenIdTokenResponseValidator;
import io.micronaut.security.oauth2.grants.GrantType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
@Internal
class PasswordGrantFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordGrantFactory.class);

    PasswordGrantFactory() {
    }

    @EachBean(value=OauthClientConfiguration.class)
    AuthenticationProvider passwordGrantProvider(@Parameter OauthClientConfiguration clientConfiguration, @Parameter @Nullable OauthUserDetailsMapper userDetailsMapper, @Parameter @Nullable OpenIdUserDetailsMapper openIdUserDetailsMapper, @Parameter @Nullable OpenIdProviderMetadata openIdProviderMetadata, TokenEndpointClient tokenEndpointClient, @Nullable DefaultOpenIdUserDetailsMapper defaultOpenIdUserDetailsMapper, @Nullable OpenIdTokenResponseValidator tokenResponseValidator) {
        if (clientConfiguration.isEnabled()) {
            if (clientConfiguration.getGrantType() == GrantType.PASSWORD) {
                if (clientConfiguration.getToken().isPresent()) {
                    if (userDetailsMapper != null) {
                        return new OauthPasswordAuthenticationProvider(tokenEndpointClient, clientConfiguration, userDetailsMapper);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Skipped password grant flow for provider [{}] because no user details mapper could be found", (Object)clientConfiguration.getName());
                    }
                } else if (clientConfiguration.getOpenid().isPresent()) {
                    if (openIdProviderMetadata != null && tokenResponseValidator != null) {
                        if (openIdUserDetailsMapper == null) {
                            openIdUserDetailsMapper = defaultOpenIdUserDetailsMapper;
                        }
                        if (openIdUserDetailsMapper != null) {
                            return new OpenIdPasswordAuthenticationProvider(clientConfiguration, openIdProviderMetadata, tokenEndpointClient, openIdUserDetailsMapper, tokenResponseValidator);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Skipped password grant flow for provider [{}] because no user details mapper could be found", (Object)clientConfiguration.getName());
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Skipped password grant flow for provider [{}] because no provider metadata and token validator could be found", (Object)clientConfiguration.getName());
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Skipped password grant flow for provider [{}] because no token endpoint or openid configuration was found", (Object)clientConfiguration.getName());
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Skipped password grant flow for provider [{}] because the grant type is not 'password'", (Object)clientConfiguration.getName());
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Skipped password grant flow for provider [{}] because the configuration is disabled", (Object)clientConfiguration.getName());
        }
        return null;
    }
}

