/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.security.ldap.context;

import io.micronaut.configuration.security.ldap.context.ContextBuilder;
import io.micronaut.configuration.security.ldap.context.ContextSettings;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.inject.Singleton;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultContextBuilder
implements ContextBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultContextBuilder.class);

    @Override
    public DirContext build(ContextSettings contextSettings) throws NamingException {
        return this.build(contextSettings.getFactory(), contextSettings.getUrl(), contextSettings.getDn(), contextSettings.getPassword(), contextSettings.getPooled(), contextSettings.getAdditionalProperties());
    }

    @Override
    public DirContext build(String factory, String server, String user, String password, boolean pooled) throws NamingException {
        return this.build(factory, server, user, password, pooled, Collections.emptyMap());
    }

    private DirContext build(String factory, String server, String user, String password, boolean pooled, Map<String, Object> additionalProperties) throws NamingException {
        Properties props = new Properties();
        props.put("java.naming.factory.initial", factory);
        props.put("java.naming.provider.url", server);
        props.put("java.naming.security.authentication", "simple");
        props.put("java.naming.security.principal", user);
        props.put("java.naming.security.credentials", password);
        if (pooled) {
            props.put("com.sun.jndi.ldap.connect.pool", "true");
        }
        if (!additionalProperties.isEmpty()) {
            props.putAll(additionalProperties);
        }
        return new InitialDirContext(props);
    }

    @Override
    public void close(DirContext context) {
        block3: {
            if (context != null) {
                try {
                    context.close();
                }
                catch (Throwable e) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("Exception occurred while closing an LDAP context", e);
                }
            }
        }
    }
}

