/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.security.ldap.group;

import io.micronaut.configuration.security.ldap.context.LdapSearchResult;
import io.micronaut.configuration.security.ldap.context.SearchProvider;
import io.micronaut.configuration.security.ldap.group.LdapGroupProcessor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Singleton;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultLdapGroupProcessor
implements LdapGroupProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLdapGroupProcessor.class);

    @Override
    public Set<String> process(String attribute, LdapSearchResult result, SearchProvider groupResults) throws NamingException {
        HashSet<String> groupSet = new HashSet<String>();
        List<LdapSearchResult> groupSearch = groupResults.get();
        if (groupSearch.isEmpty() && LOG.isDebugEnabled()) {
            LOG.debug("No groups found!");
        }
        for (LdapSearchResult groupResult : groupSearch) {
            groupResult.getAttributes().get((CharSequence)attribute, List.class).ifPresent(groups -> {
                for (Object group : groups) {
                    this.processGroup(group.toString()).ifPresent(groupSet::add);
                }
            });
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("The following groups were found for [{}]: {}", (Object)result.getDn(), groupSet);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attempting to add any additional groups...");
        }
        groupSet.addAll(this.getAdditionalGroups(result));
        return groupSet;
    }
}

