/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.validator;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.token.AbstractTokenAuthenticationFactory;
import io.micronaut.security.token.Claims;
import io.micronaut.security.token.MapClaims;
import io.micronaut.security.token.RolesFinder;
import io.micronaut.security.token.config.TokenConfiguration;
import io.micronaut.security.token.jwt.validator.JwtAuthenticationFactory;
import jakarta.inject.Singleton;
import java.text.ParseException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultJwtAuthenticationFactory
extends AbstractTokenAuthenticationFactory<JWT>
implements JwtAuthenticationFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJwtAuthenticationFactory.class);

    public DefaultJwtAuthenticationFactory(TokenConfiguration tokenConfiguration, RolesFinder rolesFinder) {
        super(tokenConfiguration, rolesFinder);
    }

    @Override
    public Optional<Authentication> createAuthentication(JWT token) {
        try {
            JWTClaimsSet claimSet = token.getJWTClaimsSet();
            if (claimSet == null) {
                return Optional.empty();
            }
            return this.createAuthentication(claimSet.getClaims());
        }
        catch (ParseException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("ParseException creating authentication", (Throwable)e);
            }
            return Optional.empty();
        }
    }

    @Deprecated
    protected Optional<String> usernameForClaims(JWTClaimsSet claimSet) throws ParseException {
        return super.usernameForClaims((Claims)new MapClaims(claimSet.getClaims()));
    }
}

