/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.nimbus;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jwt.SignedJWT;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.security.token.jwt.signature.ReactiveSignatureConfiguration;
import io.micronaut.security.token.jwt.signature.SignatureConfiguration;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class NimbusReactiveSignatureConfigurationAdapter
implements ReactiveSignatureConfiguration<SignedJWT> {
    private static final Logger LOG = LoggerFactory.getLogger(NimbusReactiveSignatureConfigurationAdapter.class);
    private final SignatureConfiguration signatureConfiguration;

    public NimbusReactiveSignatureConfigurationAdapter(SignatureConfiguration signatureConfiguration) {
        this.signatureConfiguration = signatureConfiguration;
    }

    @Override
    @SingleResult
    @NonNull
    public Publisher<Boolean> verify(@NonNull SignedJWT jwt) {
        try {
            boolean result = this.signatureConfiguration.verify(jwt);
            if (LOG.isDebugEnabled()) {
                if (result) {
                    LOG.debug("JWT signature verified");
                } else {
                    LOG.debug("JWT signature not verified");
                }
            }
            return Mono.just((Object)result);
        }
        catch (JOSEException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error verifying JWT signature", (Throwable)e);
            }
            return Mono.just((Object)false);
        }
    }
}

