/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.validator;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.filters.SecurityFilter;
import io.micronaut.security.session.SessionIdResolver;
import io.micronaut.security.token.jwt.validator.JsonWebTokenParser;
import jakarta.inject.Singleton;
import java.util.Optional;

@Requirements(value={@Requires(property="micronaut.security.sessionid-resolver.jwt-id.enabled", value="true", defaultValue="true"), @Requires(classes={HttpRequest.class}), @Requires(bean=JsonWebTokenParser.class)})
@Singleton
@Internal
final class JsonWebTokenIdSessionIdResolver
implements SessionIdResolver<HttpRequest<?>> {
    private final JsonWebTokenParser<?> jsonWebTokenParser;

    public JsonWebTokenIdSessionIdResolver(JsonWebTokenParser<?> jsonWebTokenParser) {
        this.jsonWebTokenParser = jsonWebTokenParser;
    }

    @NonNull
    public Optional<String> findSessionId(@NonNull HttpRequest<?> request) {
        return request.getAttribute(SecurityFilter.TOKEN, String.class).flatMap(this.jsonWebTokenParser::parseClaims).flatMap(claims -> Optional.ofNullable(claims.get("jti")).map(Object::toString));
    }
}

