/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.signature.jwks;

import com.nimbusds.jose.jwk.JWKSet;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.security.token.jwt.signature.jwks.JWKSetJwksSignature;
import io.micronaut.security.token.jwt.signature.jwks.JwkValidator;
import io.micronaut.security.token.jwt.signature.jwks.StaticJwksSignatureConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Optional;

@Requires(bean=ResourceResolver.class)
@EachBean(value=StaticJwksSignatureConfiguration.class)
public class StaticJwksSignature
extends JWKSetJwksSignature {
    public StaticJwksSignature(StaticJwksSignatureConfiguration staticJwksSignatureConfiguration, ResourceResolver resourceResolver, JwkValidator jwkValidator) {
        super(jwkValidator, StaticJwksSignature.jwkSet(staticJwksSignatureConfiguration, resourceResolver));
    }

    @NonNull
    private static JWKSet jwkSet(StaticJwksSignatureConfiguration staticJwksSignatureConfiguration, ResourceResolver resourceResolver) throws ConfigurationException {
        Optional inputStreamOptional = resourceResolver.getResourceAsStream(staticJwksSignatureConfiguration.getPath());
        if (!inputStreamOptional.isPresent()) {
            throw new ConfigurationException("could not load resource for path " + staticJwksSignatureConfiguration.getPath());
        }
        InputStream inputStream = (InputStream)inputStreamOptional.get();
        try {
            return JWKSet.load((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new ConfigurationException("IOException loading JWKSet for resource at path " + staticJwksSignatureConfiguration.getPath());
        }
        catch (ParseException e) {
            throw new ConfigurationException("ParseException loading JWKSet for resource at path " + staticJwksSignatureConfiguration.getPath());
        }
    }
}

