/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.signature.jwks;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jwt.SignedJWT;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.security.token.jwt.signature.jwks.JwkValidator;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class JwksSignatureUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JwksSignatureUtils.class);

    private JwksSignatureUtils() {
    }

    public static boolean verify(SignedJWT jwt, JWKSet jwkSet, JwkValidator jwkValidator) throws JOSEException {
        List<JWK> matches = JwksSignatureUtils.matches(jwt, jwkSet, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found {} matching JWKs", (Object)matches.size());
        }
        return CollectionUtils.isNotEmpty(matches) && JwksSignatureUtils.verify(jwkValidator, matches, jwt);
    }

    public static boolean supports(JWSAlgorithm algorithm, JWKSet jwkSet) {
        return JwksSignatureUtils.supports(algorithm, jwkSet.getKeys());
    }

    public static boolean supports(JWSAlgorithm algorithm, List<JWK> keys) {
        return keys.stream().map(JWK::getAlgorithm).filter(Objects::nonNull).anyMatch(arg_0 -> ((JWSAlgorithm)algorithm).equals(arg_0));
    }

    public static String supportedAlgorithmsMessage(JWKSet jwkSet) {
        return JwksSignatureUtils.supportedAlgorithmsMessage(jwkSet.getKeys());
    }

    public static String supportedAlgorithmsMessage(List<JWK> keys) {
        return keys.stream().map(JWK::getAlgorithm).filter(Objects::nonNull).map(Algorithm::getName).distinct().reduce((a, b) -> a + ", " + b).map(s -> "Algorithms supported: " + s).orElse("No algorithms are supported");
    }

    public static boolean verify(JwkValidator jwkValidator, List<JWK> matches, SignedJWT jwt) {
        return matches.stream().anyMatch(jwk -> jwkValidator.validate(jwt, (JWK)jwk));
    }

    public static List<JWK> matches(SignedJWT jwt, @Nullable JWKSet jwkSet, @Nullable KeyType keyType) {
        List matches = Collections.emptyList();
        if (jwkSet != null) {
            JWKMatcher.Builder builder = new JWKMatcher.Builder();
            if (keyType != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Key Type: {}", (Object)keyType);
                }
                builder = builder.keyType(keyType);
            }
            String keyId = jwt.getHeader().getKeyID();
            if (LOG.isDebugEnabled()) {
                LOG.debug("JWT Key ID: {}", (Object)keyId);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("JWK Set Key IDs: {}", (Object)jwkSet.getKeys().stream().map(JWK::getKeyID).collect(Collectors.joining(",")));
            }
            if (keyId != null) {
                builder = builder.keyID(keyId);
            }
            matches = new JWKSelector(builder.build()).select(jwkSet);
        }
        return matches;
    }
}

