/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.nimbus;

import com.nimbusds.jwt.SignedJWT;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.security.token.jwt.nimbus.NimbusReactiveSignatureConfigurationAdapter;
import io.micronaut.security.token.jwt.signature.ReactiveSignatureConfiguration;
import io.micronaut.security.token.jwt.signature.SignatureConfiguration;
import io.micronaut.security.token.jwt.validator.ReactiveJsonWebTokenSignatureValidator;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Internal
@Singleton
class NimbusReactiveJsonWebTokenSignatureValidator
implements ReactiveJsonWebTokenSignatureValidator<SignedJWT> {
    private final List<ReactiveSignatureConfiguration<SignedJWT>> signatures;

    public NimbusReactiveJsonWebTokenSignatureValidator(List<SignatureConfiguration> signatureConfigurations, List<ReactiveSignatureConfiguration<SignedJWT>> reactiveSignatureConfigurations) {
        this.signatures = NimbusReactiveJsonWebTokenSignatureValidator.signatures(signatureConfigurations, reactiveSignatureConfigurations);
    }

    @Override
    @SingleResult
    public Publisher<Boolean> validateSignature(@NonNull SignedJWT signedToken) {
        return Flux.fromIterable(this.signatures).flatMap(signatureConfiguration -> signatureConfiguration.verify(signedToken)).filter(Boolean::booleanValue).next();
    }

    private static List<ReactiveSignatureConfiguration<SignedJWT>> signatures(List<SignatureConfiguration> signatureConfigurations, List<ReactiveSignatureConfiguration<SignedJWT>> reactiveSignatureConfigurations) {
        ArrayList<ReactiveSignatureConfiguration<SignedJWT>> signatures = new ArrayList<ReactiveSignatureConfiguration<SignedJWT>>();
        signatures.addAll(signatureConfigurations.stream().map(NimbusReactiveSignatureConfigurationAdapter::new).toList());
        signatures.addAll(reactiveSignatureConfigurations);
        OrderUtil.sort(signatures);
        return signatures;
    }
}

