/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.nimbus;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.SignedJWT;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.security.token.jwt.encryption.EncryptionConfiguration;
import io.micronaut.security.token.jwt.validator.JsonWebTokenEncryption;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Internal
class NimbusJsonWebTokenEncryption
implements JsonWebTokenEncryption<EncryptedJWT, SignedJWT> {
    private static final Logger LOG = LoggerFactory.getLogger(NimbusJsonWebTokenEncryption.class);
    private final List<EncryptionConfiguration> encryptionConfigurationList;

    NimbusJsonWebTokenEncryption(List<EncryptionConfiguration> encryptionConfigurationList) {
        this.encryptionConfigurationList = encryptionConfigurationList;
    }

    @Override
    @NonNull
    public Optional<SignedJWT> decrypt(@NonNull EncryptedJWT jwt) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validating encrypted JWT");
        }
        if (LOG.isDebugEnabled() && this.encryptionConfigurationList.isEmpty()) {
            LOG.debug("JWT is encrypted and no encryption configurations -> not verified");
            return Optional.empty();
        }
        JWEHeader header = jwt.getHeader();
        ArrayList<EncryptionConfiguration> sortedConfigs = new ArrayList<EncryptionConfiguration>(this.encryptionConfigurationList);
        sortedConfigs.sort(NimbusJsonWebTokenEncryption.comparator(header));
        for (EncryptionConfiguration config : sortedConfigs) {
            Optional<SignedJWT> signedJWT = this.decrypt(jwt, config);
            if (!signedJWT.isPresent()) continue;
            return signedJWT;
        }
        return Optional.empty();
    }

    @NonNull
    private Optional<SignedJWT> decrypt(@NonNull EncryptedJWT jwt, @NonNull EncryptionConfiguration config) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Using encryption configuration: {}", (Object)config);
        }
        try {
            config.decrypt(jwt);
            SignedJWT signedJWT = jwt.getPayload().toSignedJWT();
            if (signedJWT == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Encrypted JWT couldn't be converted to a signed JWT.");
                }
                return Optional.empty();
            }
            return Optional.of(signedJWT);
        }
        catch (JOSEException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Decryption fails with encryption configuration: {}, passing to the next one", (Object)config);
            }
            return Optional.empty();
        }
    }

    private static Comparator<EncryptionConfiguration> comparator(JWEHeader header) {
        JWEAlgorithm algorithm = header.getAlgorithm();
        EncryptionMethod method = header.getEncryptionMethod();
        return (sig, otherSig) -> {
            boolean otherSupports;
            boolean supports = sig.supports(algorithm, method);
            if (supports == (otherSupports = otherSig.supports(algorithm, method))) {
                return 0;
            }
            if (supports) {
                return -1;
            }
            return 1;
        };
    }
}

