/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.nimbus;

import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.SignedJWT;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.security.token.Claims;
import io.micronaut.security.token.jwt.generator.claims.JwtClaimsSetAdapter;
import io.micronaut.security.token.jwt.validator.JsonWebTokenEncryption;
import io.micronaut.security.token.jwt.validator.JsonWebTokenParser;
import jakarta.inject.Singleton;
import java.text.ParseException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class NimbusJsonWebTokenParser
implements JsonWebTokenParser<JWT> {
    private static final String DOT = ".";
    private static final Logger LOG = LoggerFactory.getLogger(NimbusJsonWebTokenParser.class);
    private final JsonWebTokenEncryption<EncryptedJWT, SignedJWT> jsonWebTokenEncryption;

    NimbusJsonWebTokenParser(JsonWebTokenEncryption<EncryptedJWT, SignedJWT> jsonWebTokenEncryption) {
        this.jsonWebTokenEncryption = jsonWebTokenEncryption;
    }

    @Override
    @NonNull
    public Optional<JWT> parse(@NonNull String token) {
        block5: {
            try {
                if (this.hasAtLeastTwoDots(token)) {
                    EncryptedJWT encryptedJWT;
                    Optional<SignedJWT> optionalSignedJWT;
                    JWT jwt = JWTParser.parse((String)token);
                    if (jwt instanceof EncryptedJWT && (optionalSignedJWT = this.jsonWebTokenEncryption.decrypt(encryptedJWT = (EncryptedJWT)jwt)).isPresent()) {
                        jwt = (JWT)optionalSignedJWT.get();
                    }
                    return Optional.of(jwt);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("token {} does not contain two dots", (Object)token);
                }
            }
            catch (ParseException e) {
                if (!LOG.isTraceEnabled()) break block5;
                LOG.trace("Failed to parse JWT: {}", (Object)e.getMessage());
            }
        }
        return Optional.empty();
    }

    @Override
    @NonNull
    public Optional<Claims> parseClaims(@NonNull String token) {
        Optional<JWT> jwtOptional = this.parse(token);
        if (jwtOptional.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(new JwtClaimsSetAdapter(jwtOptional.get().getJWTClaimsSet()));
        }
        catch (ParseException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Failed to parse JWT Claims", (Throwable)e);
            }
            return Optional.empty();
        }
    }

    private boolean hasAtLeastTwoDots(String token) {
        return token.contains(DOT) && token.indexOf(DOT, token.indexOf(DOT) + 1) != -1;
    }
}

