/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.validator;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.token.jwt.encryption.EncryptionConfiguration;
import io.micronaut.security.token.jwt.signature.SignatureConfiguration;
import io.micronaut.security.token.jwt.validator.GenericJwtClaimsValidator;
import io.micronaut.security.token.jwt.validator.JwtAuthenticationFactory;
import io.micronaut.security.token.jwt.validator.JwtValidator;
import io.micronaut.security.token.validator.TokenValidator;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Singleton
public class JwtTokenValidator<T>
implements TokenValidator<T> {
    protected final JwtAuthenticationFactory jwtAuthenticationFactory;
    protected final JwtValidator<T> validator;

    @Inject
    public JwtTokenValidator(Collection<SignatureConfiguration> signatureConfigurations, Collection<EncryptionConfiguration> encryptionConfigurations, Collection<GenericJwtClaimsValidator> genericJwtClaimsValidators, JwtAuthenticationFactory jwtAuthenticationFactory) {
        this(JwtValidator.builder().withSignatures(signatureConfigurations).withEncryptions(encryptionConfigurations).withClaimValidators(genericJwtClaimsValidators).build(), jwtAuthenticationFactory);
    }

    public JwtTokenValidator(JwtValidator<T> validator, JwtAuthenticationFactory jwtAuthenticationFactory) {
        this.validator = validator;
        this.jwtAuthenticationFactory = jwtAuthenticationFactory;
    }

    public Publisher<Authentication> validateToken(String token, @Nullable T request) {
        return (Publisher)this.validator.validate(token, request).flatMap(this.jwtAuthenticationFactory::createAuthentication).map(Flux::just).orElse(Flux.empty());
    }
}

