/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.endpoints;

import com.nimbusds.jose.jwk.JWKSet;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.json.JsonMapper;
import io.micronaut.security.annotation.Secured;
import io.micronaut.security.token.jwt.endpoints.JwkProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Requirements(value={@Requires(classes={Controller.class}), @Requires(property="micronaut.security.endpoints.keys.enabled", notEquals="false", defaultValue="true"), @Requires(beans={JwkProvider.class})})
@Controller(value="${micronaut.security.endpoints.keys.path:/keys}")
@Secured(value={"isAnonymous()"})
public class KeysController {
    private static final Logger LOG = LoggerFactory.getLogger(KeysController.class);
    private static final String EMPTY_KEYS = "{\"keys\":[]}";
    private final Collection<JwkProvider> jwkProviders;
    private final JsonMapper jsonMapper;

    public KeysController(Collection<JwkProvider> jwkProviders, JsonMapper jsonMapper) {
        this.jwkProviders = jwkProviders;
        this.jsonMapper = jsonMapper;
    }

    @Get
    @SingleResult
    public Publisher<String> keys() {
        if (this.jwkProviders.isEmpty()) {
            return Mono.just((Object)EMPTY_KEYS);
        }
        return Flux.fromIterable(this.jwkProviders).flatMapIterable(JwkProvider::retrieveJsonWebKeys).collectList().map(JWKSet::new).map(JWKSet::toJSONObject).map(m -> {
            block3: {
                if (!((Collection)m.getOrDefault("keys", Collections.emptyList())).isEmpty()) {
                    try {
                        return new String(this.jsonMapper.writeValueAsBytes(m));
                    }
                    catch (IOException e) {
                        if (!LOG.isErrorEnabled()) break block3;
                        LOG.error("JSON Processing exception getting JSON representation of the JSON Web Key sets");
                    }
                }
            }
            return EMPTY_KEYS;
        });
    }
}

