/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.render;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.constraints.NotBlank;

@Serdeable
public class AccessRefreshToken {
    @JsonProperty(value="access_token")
    @NonNull
    @NotBlank
    private final String accessToken;
    @JsonProperty(value="refresh_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    private final String refreshToken;
    @JsonProperty(value="token_type")
    @NonNull
    @NotBlank
    private final String tokenType;
    @JsonProperty(value="expires_in")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    private Integer expiresIn;

    public AccessRefreshToken(@NonNull String accessToken, @Nullable String refreshToken, @NonNull String tokenType, @Nullable Integer expiresIn) {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.tokenType = tokenType;
        this.expiresIn = expiresIn;
    }

    @NonNull
    public String getAccessToken() {
        return this.accessToken;
    }

    @Nullable
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @NonNull
    public String getTokenType() {
        return this.tokenType;
    }

    @Nullable
    public Integer getExpiresIn() {
        return this.expiresIn;
    }
}

