/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.endpoints;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Pattern;

@Serdeable
public class TokenRefreshRequest {
    public static final String GRANT_TYPE_REFRESH_TOKEN = "refresh_token";
    public static final String GRANT_TYPE = "grant_type";
    @NonNull
    @NotBlank
    @Pattern(regexp="refresh_token")
    @JsonProperty(value="grant_type")
    private final @NotBlank @Pattern(regexp="refresh_token") String grantType;
    @NotBlank
    @JsonProperty(value="refresh_token")
    @NonNull
    private final String refreshToken;

    public TokenRefreshRequest(@NonNull String grantType, @NonNull String refreshToken) {
        this.grantType = grantType;
        this.refreshToken = refreshToken;
    }

    @NonNull
    public String getGrantType() {
        return this.grantType;
    }

    @NonNull
    public String getRefreshToken() {
        return this.refreshToken;
    }
}

