/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.endpoints;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.CookieValue;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.security.annotation.Secured;
import io.micronaut.security.errors.ErrorCode;
import io.micronaut.security.errors.IssuingAnAccessTokenErrorCode;
import io.micronaut.security.errors.OauthErrorResponseException;
import io.micronaut.security.handlers.LoginHandler;
import io.micronaut.security.token.jwt.endpoints.OauthControllerConfigurationProperties;
import io.micronaut.security.token.jwt.endpoints.TokenRefreshRequest;
import io.micronaut.security.token.refresh.RefreshTokenPersistence;
import io.micronaut.security.token.validator.RefreshTokenValidator;
import io.micronaut.validation.Validated;
import java.util.Optional;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Requirements(value={@Requires(property="micronaut.security.endpoints.oauth.enabled", notEquals="false"), @Requires(beans={RefreshTokenPersistence.class}), @Requires(beans={RefreshTokenValidator.class})})
@Controller(value="${micronaut.security.endpoints.oauth.path:/oauth/access_token}")
@Secured(value={"isAnonymous()"})
@Validated
public class OauthController {
    private final RefreshTokenPersistence refreshTokenPersistence;
    private final RefreshTokenValidator refreshTokenValidator;
    private final OauthControllerConfigurationProperties oauthControllerConfigurationProperties;
    private final LoginHandler loginHandler;

    public OauthController(RefreshTokenPersistence refreshTokenPersistence, RefreshTokenValidator refreshTokenValidator, OauthControllerConfigurationProperties oauthControllerConfigurationProperties, LoginHandler loginHandler) {
        this.refreshTokenPersistence = refreshTokenPersistence;
        this.refreshTokenValidator = refreshTokenValidator;
        this.oauthControllerConfigurationProperties = oauthControllerConfigurationProperties;
        this.loginHandler = loginHandler;
    }

    @Consumes(value={"application/x-www-form-urlencoded", "application/json"})
    @Post
    @SingleResult
    public Publisher<MutableHttpResponse<?>> index(HttpRequest<?> request, @Nullable @Body TokenRefreshRequest tokenRefreshRequest, @Nullable @CookieValue(value="JWT_REFRESH_TOKEN") String cookieRefreshToken) {
        String refreshToken = this.resolveRefreshToken(tokenRefreshRequest, cookieRefreshToken);
        return this.createResponse(request, refreshToken);
    }

    @Get
    @SingleResult
    public Publisher<MutableHttpResponse<?>> index(HttpRequest<?> request, @Nullable @CookieValue(value="JWT_REFRESH_TOKEN") String cookieRefreshToken) {
        if (!this.oauthControllerConfigurationProperties.isGetAllowed()) {
            return Mono.just((Object)HttpResponse.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED));
        }
        String refreshToken = this.resolveRefreshToken(null, cookieRefreshToken);
        return this.createResponse(request, refreshToken);
    }

    @SingleResult
    private Publisher<MutableHttpResponse<?>> createResponse(HttpRequest<?> request, String refreshToken) {
        Optional validRefreshToken = this.refreshTokenValidator.validate(refreshToken);
        if (!validRefreshToken.isPresent()) {
            throw new OauthErrorResponseException((ErrorCode)IssuingAnAccessTokenErrorCode.INVALID_GRANT, "Refresh token is invalid", null);
        }
        return Mono.from((Publisher)this.refreshTokenPersistence.getAuthentication((String)validRefreshToken.get())).map(authentication -> this.loginHandler.loginRefresh(authentication, refreshToken, request));
    }

    @NonNull
    private String resolveRefreshToken(TokenRefreshRequest tokenRefreshRequest, String cookieRefreshToken) {
        String refreshToken = null;
        if (tokenRefreshRequest != null) {
            if (StringUtils.isEmpty((CharSequence)tokenRefreshRequest.getGrantType()) || StringUtils.isEmpty((CharSequence)tokenRefreshRequest.getRefreshToken())) {
                throw new OauthErrorResponseException((ErrorCode)IssuingAnAccessTokenErrorCode.INVALID_REQUEST, "refresh_token and grant_type are required", null);
            }
            if (!tokenRefreshRequest.getGrantType().equals("refresh_token")) {
                throw new OauthErrorResponseException((ErrorCode)IssuingAnAccessTokenErrorCode.UNSUPPORTED_GRANT_TYPE, "grant_type must be refresh_token", null);
            }
            refreshToken = tokenRefreshRequest.getRefreshToken();
        } else if (cookieRefreshToken != null) {
            refreshToken = cookieRefreshToken;
        } else {
            throw new OauthErrorResponseException((ErrorCode)IssuingAnAccessTokenErrorCode.INVALID_REQUEST, "refresh_token and grant_type are required", null);
        }
        if (StringUtils.isEmpty((CharSequence)refreshToken)) {
            throw new OauthErrorResponseException((ErrorCode)IssuingAnAccessTokenErrorCode.INVALID_REQUEST, "refresh_token is required", null);
        }
        return refreshToken;
    }
}

