/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.cookie;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.authentication.CookieBasedAuthenticationModeCondition;
import io.micronaut.security.token.jwt.cookie.AbstractAccessTokenCookieConfigurationProperties;
import io.micronaut.security.token.jwt.cookie.AccessTokenCookieConfiguration;
import java.util.Optional;

@Requirements(value={@Requires(condition=CookieBasedAuthenticationModeCondition.class), @Requires(property="micronaut.security.token.jwt.cookie.enabled", notEquals="false", defaultValue="true")})
@ConfigurationProperties(value="micronaut.security.token.jwt.cookie")
public class JwtCookieConfigurationProperties
extends AbstractAccessTokenCookieConfigurationProperties
implements AccessTokenCookieConfiguration {
    public static final String PREFIX = "micronaut.security.token.jwt.cookie";
    public static final boolean DEFAULT_ENABLED = true;
    public static final String DEFAULT_COOKIENAME = "JWT";
    public static final String DEFAULT_COOKIEPATH = "/";
    private String cookiePath = "/";
    private boolean enabled = true;
    private String cookieName = "JWT";

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    @NonNull
    public String getCookieName() {
        return this.cookieName;
    }

    @Nullable
    public Optional<String> getCookiePath() {
        return Optional.ofNullable(this.cookiePath);
    }

    public void setCookiePath(@Nullable String cookiePath) {
        this.cookiePath = cookiePath;
    }
}

