/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.cookie;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.functional.ThrowingSupplier;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.config.RedirectConfiguration;
import io.micronaut.security.config.RedirectService;
import io.micronaut.security.config.RefreshRedirectConfiguration;
import io.micronaut.security.errors.PriorToLoginPersistence;
import io.micronaut.security.handlers.RedirectingLoginHandler;
import io.micronaut.security.token.jwt.cookie.AccessTokenCookieConfiguration;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;

public abstract class CookieLoginHandler
implements RedirectingLoginHandler {
    protected final AccessTokenCookieConfiguration accessTokenCookieConfiguration;
    protected final PriorToLoginPersistence priorToLoginPersistence;
    @Nullable
    protected final String loginFailure;
    @Nullable
    protected final String loginSuccess;
    @Nullable
    protected final String refresh;

    protected CookieLoginHandler(AccessTokenCookieConfiguration accessTokenCookieConfiguration, RedirectConfiguration redirectConfiguration, RedirectService redirectService, @Nullable PriorToLoginPersistence priorToLoginPersistence) {
        this.loginFailure = redirectConfiguration.isEnabled() ? redirectService.loginFailureUrl() : null;
        this.loginSuccess = redirectConfiguration.isEnabled() ? redirectService.loginSuccessUrl() : null;
        RefreshRedirectConfiguration refreshConfig = redirectConfiguration.getRefresh();
        this.refresh = redirectConfiguration.isEnabled() && refreshConfig.isEnabled() ? redirectService.refreshUrl() : null;
        this.accessTokenCookieConfiguration = accessTokenCookieConfiguration;
        this.priorToLoginPersistence = priorToLoginPersistence;
    }

    public abstract List<Cookie> getCookies(Authentication var1, HttpRequest<?> var2);

    public abstract List<Cookie> getCookies(Authentication var1, String var2, HttpRequest<?> var3);

    public MutableHttpResponse<?> loginSuccess(Authentication authentication, HttpRequest<?> request) {
        return this.applyCookies(this.createSuccessResponse(request), this.getCookies(authentication, request));
    }

    public MutableHttpResponse<?> loginFailed(AuthenticationResponse authenticationFailed, HttpRequest<?> request) {
        try {
            if (this.loginFailure == null) {
                return HttpResponse.ok();
            }
            URI location = new URI(this.loginFailure);
            return HttpResponse.seeOther((URI)location);
        }
        catch (URISyntaxException e) {
            return HttpResponse.serverError();
        }
    }

    public MutableHttpResponse<?> loginRefresh(Authentication authentication, String refreshToken, HttpRequest<?> request) {
        return this.applyCookies(this.createRefreshResponse(request), this.getCookies(authentication, refreshToken, request));
    }

    protected MutableHttpResponse<?> createSuccessResponse(HttpRequest<?> request) {
        try {
            Optional originalUri;
            if (this.loginSuccess == null) {
                return HttpResponse.ok();
            }
            MutableHttpResponse response = HttpResponse.status((HttpStatus)HttpStatus.SEE_OTHER);
            ThrowingSupplier uriSupplier = () -> new URI(this.loginSuccess);
            if (this.priorToLoginPersistence != null && (originalUri = this.priorToLoginPersistence.getOriginalUri(request, response)).isPresent()) {
                uriSupplier = originalUri::get;
            }
            response.getHeaders().location((URI)uriSupplier.get());
            return response;
        }
        catch (URISyntaxException e) {
            return HttpResponse.serverError();
        }
    }

    protected MutableHttpResponse<?> createRefreshResponse(HttpRequest<?> request) {
        try {
            if (this.refresh != null) {
                return HttpResponse.seeOther((URI)new URI(this.refresh));
            }
            return HttpResponse.ok();
        }
        catch (URISyntaxException e) {
            return HttpResponse.serverError();
        }
    }

    protected MutableHttpResponse<?> applyCookies(MutableHttpResponse<?> response, List<Cookie> cookies) {
        for (Cookie cookie : cookies) {
            response = response.cookie(cookie);
        }
        return response;
    }
}

