/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.signature.secret;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jose.crypto.impl.MACProvider;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.security.token.jwt.signature.AbstractSignatureConfiguration;
import io.micronaut.security.token.jwt.signature.SignatureGeneratorConfiguration;
import io.micronaut.security.token.jwt.signature.secret.SecretSignatureConfiguration;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;

@EachBean(value=SecretSignatureConfiguration.class)
public class SecretSignature
extends AbstractSignatureConfiguration
implements SignatureGeneratorConfiguration {
    private byte[] secret;

    public SecretSignature(SecretSignatureConfiguration config) {
        Objects.requireNonNull(config.getSecret(), "The secret for the secret signature cannot be null");
        this.secret = config.isBase64() ? Base64.getDecoder().decode(config.getSecret()) : config.getSecret().getBytes(StandardCharsets.UTF_8);
        this.algorithm = config.getJwsAlgorithm();
    }

    @Override
    public String supportedAlgorithmsMessage() {
        return "Only the HS256, HS384 and HS512 algorithms are supported for HMac signature";
    }

    @Override
    public boolean supports(JWSAlgorithm algorithm) {
        return algorithm != null && MACProvider.SUPPORTED_ALGORITHMS.contains(algorithm);
    }

    @Override
    public SignedJWT sign(JWTClaimsSet claims) throws JOSEException {
        MACSigner signer = new MACSigner(this.secret);
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(this.algorithm), claims);
        signedJWT.sign((JWSSigner)signer);
        return signedJWT;
    }

    @Override
    public boolean verify(SignedJWT jwt) throws JOSEException {
        MACVerifier verifier = new MACVerifier(this.secret);
        return jwt.verify((JWSVerifier)verifier);
    }

    public String getSecret() {
        return new String(this.secret, StandardCharsets.UTF_8);
    }

    public void setSecret(String secret) {
        this.secret = secret.getBytes(StandardCharsets.UTF_8);
    }
}

