/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.cookie;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.CookieConfiguration;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.config.RedirectConfiguration;
import io.micronaut.security.errors.ErrorCode;
import io.micronaut.security.errors.OauthErrorResponseException;
import io.micronaut.security.errors.ObtainingAuthorizationErrorCode;
import io.micronaut.security.errors.PriorToLoginPersistence;
import io.micronaut.security.token.jwt.cookie.AccessTokenCookieConfiguration;
import io.micronaut.security.token.jwt.cookie.CookieLoginHandler;
import io.micronaut.security.token.jwt.cookie.RefreshTokenCookieConfiguration;
import io.micronaut.security.token.jwt.generator.AccessRefreshTokenGenerator;
import io.micronaut.security.token.jwt.generator.AccessTokenConfiguration;
import io.micronaut.security.token.jwt.render.AccessRefreshToken;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.List;

@Requires(property="micronaut.security.authentication", value="cookie")
@Singleton
public class JwtCookieLoginHandler
extends CookieLoginHandler {
    protected final AccessRefreshTokenGenerator accessRefreshTokenGenerator;
    protected final RefreshTokenCookieConfiguration refreshTokenCookieConfiguration;
    protected final AccessTokenConfiguration accessTokenConfiguration;

    public JwtCookieLoginHandler(RedirectConfiguration redirectConfiguration, AccessTokenCookieConfiguration accessTokenCookieConfiguration, RefreshTokenCookieConfiguration refreshTokenCookieConfiguration, AccessTokenConfiguration accessTokenConfiguration, AccessRefreshTokenGenerator accessRefreshTokenGenerator, @Nullable PriorToLoginPersistence priorToLoginPersistence) {
        super(accessTokenCookieConfiguration, redirectConfiguration, priorToLoginPersistence);
        this.refreshTokenCookieConfiguration = refreshTokenCookieConfiguration;
        this.accessTokenConfiguration = accessTokenConfiguration;
        this.accessRefreshTokenGenerator = accessRefreshTokenGenerator;
    }

    @Override
    public List<Cookie> getCookies(Authentication authentication, HttpRequest<?> request) {
        AccessRefreshToken accessRefreshToken = this.accessRefreshTokenGenerator.generate(authentication).orElseThrow(() -> new OauthErrorResponseException((ErrorCode)ObtainingAuthorizationErrorCode.SERVER_ERROR, "Cannot obtain an access token", null));
        return this.getCookies(accessRefreshToken, request);
    }

    @Override
    public List<Cookie> getCookies(Authentication authentication, String refreshToken, HttpRequest<?> request) {
        AccessRefreshToken accessRefreshToken = this.accessRefreshTokenGenerator.generate(refreshToken, authentication).orElseThrow(() -> new OauthErrorResponseException((ErrorCode)ObtainingAuthorizationErrorCode.SERVER_ERROR, "Cannot obtain an access token", null));
        return this.getCookies(accessRefreshToken, request);
    }

    protected List<Cookie> getCookies(AccessRefreshToken accessRefreshToken, HttpRequest<?> request) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(2);
        Cookie jwtCookie = Cookie.of((String)this.accessTokenCookieConfiguration.getCookieName(), (String)accessRefreshToken.getAccessToken());
        jwtCookie.configure((CookieConfiguration)this.accessTokenCookieConfiguration, request.isSecure());
        TemporalAmount maxAge = this.accessTokenCookieConfiguration.getCookieMaxAge().orElseGet(() -> Duration.ofSeconds(this.accessTokenConfiguration.getExpiration().intValue()));
        jwtCookie.maxAge(maxAge);
        cookies.add(jwtCookie);
        String refreshToken = accessRefreshToken.getRefreshToken();
        if (StringUtils.isNotEmpty((CharSequence)refreshToken)) {
            Cookie refreshCookie = Cookie.of((String)this.refreshTokenCookieConfiguration.getCookieName(), (String)refreshToken);
            refreshCookie.configure((CookieConfiguration)this.refreshTokenCookieConfiguration, request.isSecure());
            refreshCookie.maxAge(this.refreshTokenCookieConfiguration.getCookieMaxAge().orElseGet(() -> Duration.ofDays(30L)));
            cookies.add(refreshCookie);
        }
        return cookies;
    }
}

