/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.signature.jwks;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jwt.SignedJWT;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.token.jwt.signature.SignatureConfiguration;
import io.micronaut.security.token.jwt.signature.jwks.JwkValidator;
import io.micronaut.security.token.jwt.signature.jwks.JwksCache;
import io.micronaut.security.token.jwt.signature.jwks.JwksSignatureConfiguration;
import jakarta.inject.Inject;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EachBean(value=JwksSignatureConfiguration.class)
public class JwksSignature
implements JwksCache,
SignatureConfiguration {
    @Deprecated
    public static final int DEFAULT_REFRESH_JWKS_ATTEMPTS = 1;
    private static final Logger LOG = LoggerFactory.getLogger(JwksSignature.class);
    private final JwkValidator jwkValidator;
    private final JwksSignatureConfiguration jwksSignatureConfiguration;
    private volatile Instant jwkSetCachedAt;
    private volatile JWKSet jwkSet;

    @Inject
    public JwksSignature(JwksSignatureConfiguration jwksSignatureConfiguration, JwkValidator jwkValidator) {
        this.jwksSignatureConfiguration = jwksSignatureConfiguration;
        this.jwkValidator = jwkValidator;
    }

    @Deprecated
    public JwksSignature(final String url, final @Nullable KeyType keyType, JwkValidator jwkValidator) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("JWT validation URL: {}", (Object)url);
        }
        this.jwksSignatureConfiguration = new JwksSignatureConfiguration(){

            @Override
            @NonNull
            public String getUrl() {
                return url;
            }

            @Override
            public KeyType getKeyType() {
                return keyType;
            }

            @Override
            @NonNull
            public Integer getCacheExpiration() {
                return 60;
            }
        };
        this.jwkValidator = jwkValidator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<JWKSet> getJWKSet() {
        JWKSet jwkSet = this.jwkSet;
        if (jwkSet == null) {
            JwksSignature jwksSignature = this;
            synchronized (jwksSignature) {
                jwkSet = this.jwkSet;
                if (jwkSet == null) {
                    this.jwkSet = jwkSet = this.loadJwkSet(this.jwksSignatureConfiguration.getUrl());
                    this.jwkSetCachedAt = Instant.now().plus((long)this.jwksSignatureConfiguration.getCacheExpiration().intValue(), ChronoUnit.SECONDS);
                }
            }
        }
        return Optional.ofNullable(jwkSet);
    }

    private List<JWK> getJsonWebKeys() {
        return this.getJWKSet().map(JWKSet::getKeys).orElse(Collections.emptyList());
    }

    @Override
    public boolean isExpired() {
        Instant cachedAt = this.jwkSetCachedAt;
        return cachedAt != null && Instant.now().isAfter(cachedAt);
    }

    @Override
    public void clear() {
        this.jwkSet = null;
        this.jwkSetCachedAt = null;
    }

    @Override
    public boolean isPresent() {
        return this.jwkSet != null;
    }

    @Override
    @NonNull
    public Optional<List<String>> getKeyIds() {
        JWKSet jwkSet = this.jwkSet;
        if (jwkSet != null) {
            ArrayList<String> keyIds = new ArrayList<String>(jwkSet.getKeys().size());
            for (JWK key : jwkSet.getKeys()) {
                String keyId = key.getKeyID();
                if (keyId == null) continue;
                keyIds.add(keyId);
            }
            if (keyIds.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(keyIds);
        }
        return Optional.empty();
    }

    @Override
    public String supportedAlgorithmsMessage() {
        String message = this.getJsonWebKeys().stream().map(JWK::getAlgorithm).map(Algorithm::getName).reduce((a, b) -> a + ", " + b).map(s -> "Only the " + s).orElse("No");
        return message + " algorithms are supported";
    }

    @Override
    public boolean supports(JWSAlgorithm algorithm) {
        return this.getJsonWebKeys().stream().map(JWK::getAlgorithm).anyMatch(arg_0 -> ((JWSAlgorithm)algorithm).equals(arg_0));
    }

    @Override
    public boolean verify(SignedJWT jwt) throws JOSEException {
        List<JWK> matches = this.matches(jwt, this.getJWKSet().orElse(null));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found {} matching JWKs", (Object)matches.size());
        }
        if (matches == null || matches.isEmpty()) {
            return false;
        }
        return this.verify(matches, jwt);
    }

    @Nullable
    protected JWKSet loadJwkSet(String url) {
        if (url == null) {
            return null;
        }
        try {
            return JWKSet.load((URL)new URL(url));
        }
        catch (IOException | ParseException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Exception loading JWK from " + url + ". The JwksSignature will not be used to verify a JWT if further refresh attempts fail", (Throwable)e);
            }
            return null;
        }
    }

    @Deprecated
    protected List<JWK> matches(SignedJWT jwt, @Nullable JWKSet jwkSet, int refreshKeysAttempts) {
        return this.matches(jwt, jwkSet);
    }

    protected List<JWK> matches(SignedJWT jwt, @Nullable JWKSet jwkSet) {
        List matches = Collections.emptyList();
        if (jwkSet != null) {
            JWKMatcher.Builder builder = new JWKMatcher.Builder();
            if (this.jwksSignatureConfiguration.getKeyType() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Key Type: {}", (Object)this.jwksSignatureConfiguration.getKeyType());
                }
                builder = builder.keyType(this.jwksSignatureConfiguration.getKeyType());
            }
            String keyId = jwt.getHeader().getKeyID();
            if (LOG.isDebugEnabled()) {
                LOG.debug("JWT Key ID: {}", (Object)keyId);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("JWK Set Key IDs: {}", (Object)String.join((CharSequence)",", this.getKeyIds().orElse(Collections.emptyList())));
            }
            if (keyId != null) {
                builder = builder.keyID(keyId);
            }
            matches = new JWKSelector(builder.build()).select(jwkSet);
        }
        return matches;
    }

    protected boolean verify(List<JWK> matches, SignedJWT jwt) {
        return matches.stream().anyMatch(jwk -> this.jwkValidator.validate(jwt, (JWK)jwk));
    }

    @Deprecated
    public int getRefreshJwksAttempts() {
        return 1;
    }

    @Deprecated
    public JwkValidator getJwkValidator() {
        return this.jwkValidator;
    }

    @Deprecated
    public JWKSet getJwkSet() {
        return this.jwkSet;
    }

    @Deprecated
    public KeyType getKeyType() {
        return this.jwksSignatureConfiguration.getKeyType();
    }

    @Deprecated
    public String getUrl() {
        return this.jwksSignatureConfiguration.getUrl();
    }
}

