/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.validator;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.authentication.AuthenticationUserDetailsAdapter;
import io.micronaut.security.authentication.UserDetails;
import io.micronaut.security.token.config.TokenConfiguration;
import io.micronaut.security.token.jwt.validator.JwtAuthenticationFactory;
import java.text.ParseException;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultJwtAuthenticationFactory
implements JwtAuthenticationFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJwtAuthenticationFactory.class);
    private final TokenConfiguration tokenConfiguration;

    public DefaultJwtAuthenticationFactory(TokenConfiguration tokenConfiguration) {
        this.tokenConfiguration = tokenConfiguration;
    }

    @Override
    public Optional<Authentication> createAuthentication(JWT token) {
        try {
            JWTClaimsSet claimSet = token.getJWTClaimsSet();
            if (claimSet == null) {
                return Optional.empty();
            }
            return this.usernameForClaims(claimSet).map(username -> new AuthenticationUserDetailsAdapter(new UserDetails(username, Collections.emptyList(), claimSet.getClaims()), this.tokenConfiguration.getRolesName(), this.tokenConfiguration.getNameKey()));
        }
        catch (ParseException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("ParseException creating authentication", (Throwable)e);
            }
            return Optional.empty();
        }
    }

    protected Optional<String> usernameForClaims(JWTClaimsSet claimSet) throws ParseException {
        String username = claimSet.getStringClaim(this.tokenConfiguration.getNameKey());
        if (username == null) {
            return Optional.ofNullable(claimSet.getSubject());
        }
        return Optional.of(username);
    }
}

