/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.endpoints;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.jwk.JWKSet;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.security.annotation.Secured;
import io.micronaut.security.token.jwt.endpoints.JwkProvider;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.util.ArrayList;
import java.util.Collection;
import net.minidev.json.JSONObject;

@Requirements(value={@Requires(property="micronaut.security.endpoints.keys.enabled", notEquals="false", defaultValue="true"), @Requires(beans={JwkProvider.class})})
@Controller(value="${micronaut.security.endpoints.keys.path:/keys}")
@Secured(value={"isAnonymous()"})
public class KeysController {
    private static final JSONObject EMPTY_KEYS = new JSONObject().appendField("keys", new ArrayList());
    private final Collection<JwkProvider> jwkProviders;
    private final ObjectMapper objectMapper;

    public KeysController(Collection<JwkProvider> jwkProviders, ObjectMapper objectMapper) {
        this.jwkProviders = jwkProviders;
        this.objectMapper = objectMapper.copy().setSerializationInclusion(JsonInclude.Include.ALWAYS);
    }

    @Get
    public Single<String> keys() {
        if (this.jwkProviders.isEmpty()) {
            return Single.just((Object)this.objectMapper).map(om -> om.writeValueAsString((Object)EMPTY_KEYS));
        }
        return Flowable.fromIterable(this.jwkProviders).flatMapIterable(JwkProvider::retrieveJsonWebKeys).toList().map(JWKSet::new).map(JWKSet::toJSONObject).map(arg_0 -> ((ObjectMapper)this.objectMapper).writeValueAsString(arg_0));
    }
}

