/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.cookie;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.CookieConfiguration;
import io.micronaut.security.authentication.UserDetails;
import io.micronaut.security.config.RedirectConfiguration;
import io.micronaut.security.errors.ErrorCode;
import io.micronaut.security.errors.OauthErrorResponseException;
import io.micronaut.security.errors.ObtainingAuthorizationErrorCode;
import io.micronaut.security.errors.PriorToLoginPersistence;
import io.micronaut.security.token.jwt.cookie.CookieLoginHandler;
import io.micronaut.security.token.jwt.cookie.JwtCookieConfiguration;
import io.micronaut.security.token.jwt.generator.AccessRefreshTokenGenerator;
import io.micronaut.security.token.jwt.generator.AccessTokenConfiguration;
import io.micronaut.security.token.jwt.render.AccessRefreshToken;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Requires(property="micronaut.security.authentication", value="cookie")
@Singleton
public class JwtCookieLoginHandler
extends CookieLoginHandler {
    protected final AccessRefreshTokenGenerator accessRefreshTokenGenerator;
    protected final AccessTokenConfiguration accessTokenConfiguration;

    @Deprecated
    public JwtCookieLoginHandler(JwtCookieConfiguration jwtCookieConfiguration, AccessTokenConfiguration accessTokenConfiguration, AccessRefreshTokenGenerator accessRefreshTokenGenerator) {
        super(jwtCookieConfiguration, jwtCookieConfiguration.getLoginSuccessTargetUrl(), jwtCookieConfiguration.getCookieName());
        this.accessTokenConfiguration = accessTokenConfiguration;
        this.accessRefreshTokenGenerator = accessRefreshTokenGenerator;
    }

    @Inject
    public JwtCookieLoginHandler(RedirectConfiguration redirectConfiguration, JwtCookieConfiguration jwtCookieConfiguration, AccessTokenConfiguration accessTokenConfiguration, AccessRefreshTokenGenerator accessRefreshTokenGenerator, @Nullable PriorToLoginPersistence priorToLoginPersistence) {
        super(jwtCookieConfiguration, redirectConfiguration, priorToLoginPersistence);
        this.accessTokenConfiguration = accessTokenConfiguration;
        this.accessRefreshTokenGenerator = accessRefreshTokenGenerator;
    }

    @Override
    protected List<Cookie> getCookies(UserDetails userDetails, HttpRequest<?> request) {
        AccessRefreshToken accessRefreshToken = this.accessRefreshTokenGenerator.generate(userDetails).orElseThrow(() -> new OauthErrorResponseException((ErrorCode)ObtainingAuthorizationErrorCode.SERVER_ERROR, "Cannot obtain an access token", null));
        return this.getCookies(accessRefreshToken, request);
    }

    @Override
    protected List<Cookie> getCookies(UserDetails userDetails, String refreshToken, HttpRequest<?> request) {
        AccessRefreshToken accessRefreshToken = this.accessRefreshTokenGenerator.generate(refreshToken, userDetails).orElseThrow(() -> new OauthErrorResponseException((ErrorCode)ObtainingAuthorizationErrorCode.SERVER_ERROR, "Cannot obtain an access token", null));
        return this.getCookies(accessRefreshToken, request);
    }

    protected List<Cookie> getCookies(AccessRefreshToken accessRefreshToken, HttpRequest<?> request) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(2);
        Cookie jwtCookie = Cookie.of((String)this.jwtCookieConfiguration.getCookieName(), (String)accessRefreshToken.getAccessToken());
        jwtCookie.configure((CookieConfiguration)this.jwtCookieConfiguration, request.isSecure());
        TemporalAmount maxAge = this.jwtCookieConfiguration.getCookieMaxAge().orElseGet(() -> Duration.ofSeconds(this.accessTokenConfiguration.getExpiration().intValue()));
        jwtCookie.maxAge(maxAge);
        cookies.add(jwtCookie);
        String refreshToken = accessRefreshToken.getRefreshToken();
        if (StringUtils.isNotEmpty((CharSequence)refreshToken)) {
            Cookie refreshCookie = Cookie.of((String)"JWT_REFRESH_TOKEN", (String)refreshToken);
            refreshCookie.configure((CookieConfiguration)this.jwtCookieConfiguration, request.isSecure());
            refreshCookie.maxAge(maxAge);
            cookies.add(refreshCookie);
        }
        return cookies;
    }
}

