/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.cookie;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.util.functional.ThrowingSupplier;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.authentication.UserDetails;
import io.micronaut.security.config.RedirectConfiguration;
import io.micronaut.security.config.RefreshRedirectConfiguration;
import io.micronaut.security.errors.PriorToLoginPersistence;
import io.micronaut.security.handlers.RedirectingLoginHandler;
import io.micronaut.security.token.jwt.cookie.JwtCookieConfiguration;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

public abstract class CookieLoginHandler
implements RedirectingLoginHandler {
    protected final JwtCookieConfiguration jwtCookieConfiguration;
    protected final PriorToLoginPersistence priorToLoginPersistence;
    protected final String loginFailure;
    protected final String loginSuccess;
    protected final String refresh;

    @Inject
    public CookieLoginHandler(JwtCookieConfiguration jwtCookieConfiguration, RedirectConfiguration redirectConfiguration, @Nullable PriorToLoginPersistence priorToLoginPersistence) {
        this.loginFailure = redirectConfiguration.getLoginFailure();
        this.loginSuccess = redirectConfiguration.getLoginSuccess();
        RefreshRedirectConfiguration refreshConfig = redirectConfiguration.getRefresh();
        this.refresh = refreshConfig.isEnabled() ? refreshConfig.getUrl() : null;
        this.jwtCookieConfiguration = jwtCookieConfiguration;
        this.priorToLoginPersistence = priorToLoginPersistence;
    }

    @Deprecated
    public CookieLoginHandler(JwtCookieConfiguration jwtCookieConfiguration, String loginSuccess, String loginFailure) {
        this.loginFailure = loginFailure;
        this.loginSuccess = loginSuccess;
        this.refresh = "/";
        this.jwtCookieConfiguration = jwtCookieConfiguration;
        this.priorToLoginPersistence = null;
    }

    protected abstract List<Cookie> getCookies(UserDetails var1, HttpRequest<?> var2);

    protected abstract List<Cookie> getCookies(UserDetails var1, String var2, HttpRequest<?> var3);

    public MutableHttpResponse<?> loginSuccess(UserDetails userDetails, HttpRequest<?> request) {
        return this.applyCookies(this.createSuccessResponse(request), this.getCookies(userDetails, request));
    }

    public MutableHttpResponse<?> loginFailed(AuthenticationResponse authenticationFailed, HttpRequest<?> request) {
        try {
            URI location = new URI(this.loginFailure);
            return HttpResponse.seeOther((URI)location);
        }
        catch (URISyntaxException e) {
            return HttpResponse.serverError();
        }
    }

    public MutableHttpResponse<?> loginRefresh(UserDetails userDetails, String refreshToken, HttpRequest<?> request) {
        return this.applyCookies(this.createRefreshResponse(request), this.getCookies(userDetails, refreshToken, request));
    }

    protected MutableHttpResponse<?> createSuccessResponse(HttpRequest<?> request) {
        try {
            Optional originalUri;
            MutableHttpResponse response = HttpResponse.status((HttpStatus)HttpStatus.SEE_OTHER);
            ThrowingSupplier uriSupplier = () -> new URI(this.loginSuccess);
            if (this.priorToLoginPersistence != null && (originalUri = this.priorToLoginPersistence.getOriginalUri(request, response)).isPresent()) {
                uriSupplier = originalUri::get;
            }
            response.getHeaders().location((URI)uriSupplier.get());
            return response;
        }
        catch (URISyntaxException e) {
            return HttpResponse.serverError();
        }
    }

    protected MutableHttpResponse<?> createRefreshResponse(HttpRequest<?> request) {
        try {
            if (this.refresh != null) {
                return HttpResponse.seeOther((URI)new URI(this.refresh));
            }
            return HttpResponse.ok();
        }
        catch (URISyntaxException e) {
            return HttpResponse.serverError();
        }
    }

    protected MutableHttpResponse<?> applyCookies(MutableHttpResponse<?> response, List<Cookie> cookies) {
        for (Cookie cookie : cookies) {
            response = response.cookie(cookie);
        }
        return response;
    }
}

