/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.csrf.resolver;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.csrf.CsrfConfiguration;
import io.micronaut.security.csrf.resolver.CsrfTokenResolver;
import jakarta.inject.Singleton;
import java.util.Optional;

@Requirements(value={@Requires(classes={HttpRequest.class}), @Requires(property="micronaut.security.csrf.token-resolvers.http-header.enabled", value="true", defaultValue="true")})
@Singleton
@Internal
final class HttpHeaderCsrfTokenResolver
implements CsrfTokenResolver<HttpRequest<?>> {
    private static final int ORDER = -100;
    private final String lowerHeaderName;
    private final String headerName;

    HttpHeaderCsrfTokenResolver(CsrfConfiguration csrfConfiguration) {
        this.headerName = csrfConfiguration.getHeaderName();
        this.lowerHeaderName = this.headerName.toLowerCase();
    }

    @Override
    @NonNull
    public Optional<String> resolveToken(@NonNull HttpRequest<?> request) {
        HttpHeaders httpHeaders = request.getHeaders();
        String csrfToken = (String)httpHeaders.get((CharSequence)this.headerName);
        if (StringUtils.isNotEmpty((CharSequence)csrfToken)) {
            return Optional.of(csrfToken);
        }
        csrfToken = (String)httpHeaders.get((CharSequence)this.lowerHeaderName);
        if (StringUtils.isNotEmpty((CharSequence)csrfToken)) {
            return Optional.of(csrfToken);
        }
        return Optional.empty();
    }

    public int getOrder() {
        return -100;
    }
}

